/* Source Installer, Copyright (c) 2005 Claudio Fontana

 package_list.h - list of managed packages

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org

*/

#ifndef SRCINST_PACKAGE_LIST_H
#define SRCINST_PACKAGE_LIST_H

/* as for now, the package list is implemented with a d-linked list */

struct _package_element {
  struct _package_info* info;

  struct _package_element* next;
  struct _package_element* prev;
};

struct _package_list {
  int mode;
  int count;

  struct _package_element* first;
  struct _package_element* last;
};

/* the initializer function for the package_list */

void _init_package_list(struct _package_list* l);

void _init_package_element(struct _package_element* e, struct _package_info* info);

void _free_package_element(struct _package_element* e);

/* remove all elements from the list, freeing memory */
void _free_package_list(struct _package_list* l);

/* The following function loads the list of known packages.
   The MODE parameter can be used to tweak the memory usage:

   If called with MODE<0, the function will load all the package names plus
   ALL package information. Browsing packages will then require no more load
   operations, but the initial load time will be long.

   If called with MODE=0, the function will load only the package names, and NO
   other package information. Browsing packages will then require a load/free
   for each package browsed. Fast initial load time, but slower
   package-to-package browsing.

   Calling with MODE>0 is reserved for future changes. Currently DO NOT
   do it, as the result is undefined.
*/

int _load_package_list(struct _package_list* l, int mode);


/* This function adds a new package element to the d-linked list.
   We start looking at the end of the list (and move backwards) for the right
   place to add the element. The list is kept in alphabetical order,
   and we start from the end because globbing could give us the
   names is alpha order. */

struct _package_element* _add_package_info(struct _package_list* l, struct _package_info* info);

/* Use this one instead if you have a ready package_element to add. */

int _add_package_element(struct _package_list* l, struct _package_element* e);

/* remove a package from the d-linked list, but do not free anything related
   to the package element. The element still exists in memory thereafter. */
void _detach_package_list(struct _package_list* l, struct _package_element* e);

/* similar to detach_package_list is the following function, that
   removes a package from the d-linked list, but also frees all info about the
   package element. */

void _remove_package_list(struct _package_list* l, struct _package_element* e);

/* Search a package list by name */

struct _package_element* _search_package_list(struct _package_list* l, char* name);


#endif /* PACKAGE_LIST_H */

