/* Source Installer, Copyright (c) 2005 Claudio Fontana

   package_info.h - package information structure and functions

   This program is free software; you can redistribute it and/or modify
       it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
       (at your option) any later version.

   This program is distributed in the hope that it will be useful,
       but WITHOUT ANY WARRANTY; without even the implied warranty of
       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
       GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
       along with this program (look for the file called COPYING);
       if not, write to the Free Software Foundation, Inc.,
           51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

       You can contact the author (Claudio Fontana) by sending a mail
       to claudio@gnu.org
*/

#ifndef SRCINST_PACKAGE_INFO_H
#define SRCINST_PACKAGE_INFO_H

/* the following structure fully describes the information about a package
   The name is a unique ID for the package,
   and is used for sorting and searching purposes.
*/

#define SRCINST_ONCLOSE_NOP 0x00    /* on close, do nothing */
#define SRCINST_ONCLOSE_UPDATE 0x01 /* on close, update this package */
#define SRCINST_ONCLOSE_ADD 0x02    /* on close, add this package */

struct _package_info {
  char loaded;
  unsigned char onclose;
  char build_ready;
  char* packdir;		/* package initialized build directory */
  char* name;

  char* description;
  char* long_description;
  char* configured;
  char* prefix;			/* keep prefix separated from configured */
  off_t source_size;
  /*  off_t padding1; */

  char* source_location;
  char* build_subdir;		/* build subdirectory. Move before build. */
  char installed;
  off_t installed_size;
  /* off_t padding2; */

  struct srcinst_string_list installed_files;
};

#define SRCINST_PACKAGE_INFO_NKEYS 14
enum {
  SRCINST_IKEY_BUILD_SUBDIR,
  SRCINST_IKEY_CONFIGURED,
  SRCINST_IKEY_D,
  SRCINST_IKEY_DESCR,
  SRCINST_IKEY_I,
  SRCINST_IKEY_INSTALLED,
  SRCINST_IKEY_INSTALLED_FILES,
  SRCINST_IKEY_INSTALLED_SIZE,
  SRCINST_IKEY_LONG_DESCR,
  SRCINST_IKEY_NAME,
  SRCINST_IKEY_PREFIX,
  SRCINST_IKEY_SOURCE_AVAILABLE,
  SRCINST_IKEY_SOURCE_LOCATION,
  SRCINST_IKEY_SOURCE_SIZE
};

extern struct srcinst_parsed_data _keywords_package_info[];

/* following function initializes pointed package_info structure */
void _init_package_info(struct _package_info* info, char* name);

/* this one loads information about a single package. The struct is filled
   with data read from the package information file. Memory allocations are
   made (by means of internal call to _parse_package_info) .
*/

int _load_package_info(struct _package_info* info);
int _save_package_info(struct _package_info* info);

/* this one is used by the preceeding one, but is also useful by itself.
   Given a keyword and a string containing the to-be-assigned value,
   the function sets the corresponding values in the struct. Allocations are
   made. */

int _parse_package_info(struct _package_info* info, char* keyword, char* value);

/* the following frees all memory allocated within the struct. */
   
void _free_package_info(struct _package_info* info);

/* delete the file that represents the structure on the file system */
int _unlink_package_info(struct _package_info* info);

#endif


