#!/usr/bin/env python
import sys, os
if os.path.isdir("soundcard"):
    sys.path.append(".")
else:
    sys.path.append("..")

import gnome.ui, gnome.config
gnome.config.push_prefix("Solfege/")
import mpd, mpd.musicdisplayer, soundcard
import gtk
from src import gu

class DisplaytestWindow(gtk.GtkWindow):
    def on_quit(self, w):
        gnome.config.sync()
    def __init__(self):
        gtk.GtkWindow.__init__(self)
        self.connect('destroy', self.on_quit)
        self.vbox = vbox = gtk.GtkVBox()
        vbox.show()
        self.add(vbox)
        self.g_text = gtk.GtkText()
        self.g_text.show()
        self.g_text.set_editable(gtk.TRUE)
        s = gnome.config.get_string('config/score_displayer')
        if not s:
            s = r"\staff{c' d' e'}"
        self.g_text.insert_defaults(s)
        vbox.pack_start(self.g_text)
        self.g_displayer = mpd.musicdisplayer.MusicDisplayer()
        self.g_displayer.set_usize(200, 200)
        self.g_displayer.show()
        self.vbox.pack_start(self.g_displayer)
        gu.bButton(vbox, "Parse", self.on_parse)
        gu.bButton(vbox, "Display", self.on_display)
        gu.bButton(vbox, "Display first notes", self.on_display_first_notes)
        gu.bButton(vbox, "Display last notes", self.on_display_last_notes)
        gu.bButton(vbox, "Play", self.on_play)
        gu.bButton(vbox, "Play first", self.on_play_first)
    def on_parse(self, _o):
        t = self.g_text.get_chars(0, -1)
        score = mpd.parser.parse_to_score_object(t)
        score.help__del__()
    def on_display(self, _o):
        t = self.g_text.get_chars(0, -1)
        gnome.config.set_string('config/score_displayer', t)
        self.g_displayer.display(t, 20)
    def on_display_first_notes(self, _o):
        t = self.g_text.get_chars(0, -1)
        gnome.config.set_string('config/score_displayer', t)
        self.g_displayer.display(t, 20, mpd.FIRST)
    def on_display_last_notes(self, _o):
        t = self.g_text.get_chars(0, -1)
        gnome.config.set_string('config/score_displayer', t)
        self.g_displayer.display(t, 20, mpd.LAST)
    def on_play(self, _o):
        t = self.g_text.get_chars(0, -1)
        gnome.config.set_string('config/score_displayer', t)
        mpd.play_music(t, (120, 4), 40)
    def on_play_first(self, _o):
        t = self.g_text.get_chars(0, -1)
        tr = mpd.music_to_track(t, soundcard.rat.Rat(0, 1), soundcard.rat.Rat(1, 8))
        soundcard.synth.play_track(tr)

#soundcard.initialise_external_midiplayer("drvmidi -i d %s")
soundcard.initialise_devicefile("/dev/music", 0)
#soundcard.initialise_using_fake_synth()

w = DisplaytestWindow()
w.connect('destroy', gtk.mainquit)
w.show()

gtk.mainloop()
