"======================================================================
|
|   SmallInteger Method Definitions
|
|   $Revision: 1.8.5$
|   $Date: 2000/12/27 10:45:49$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"


Integer subclass: #SmallInteger
       instanceVariableNames: ''
       classVariableNames: ''
       poolDictionaries: ''
       category: 'Language-Data types'
!

Integer comment:
'I am the integer class of the GNU Smalltalk system.  My instances can 
represent signed 30 bit integers and are as efficient as possible.' !


!Integer class methodsFor: 'testing'!

isIdentity
    "Answer whether x = y implies x == y for instances of the receiver"
    ^true
! !


!Integer class methodsFor: 'getting limits'!

bits
    "Answer the number of bits (excluding the sign) that can be represented
    directly in an object pointer"
    ^CLongSize * 8 - 3
!

largest
    "Answer the largest integer represented directly in an object pointer"
    | maxBit |
    maxBit := 1 bitShift: CLongSize * 8 - 3.
    ^(maxBit - 1) + maxBit
!

smallest
    "Answer the smallest integer represented directly in an object pointer"
    | maxBit |
    maxBit := 1 bitShift: CLongSize * 8 - 3.
    ^maxBit negated - maxBit
! !


!Integer methodsFor: 'Coercion methods (heh heh heh)'!

zero
    "Coerce 0 to the receiver's class"
    ^0
!

unity
    "Coerce 1 to the receiver's class"
    ^1
!

generality
    "Return the receiver's generality"
    ^100
! !


!Integer methodsFor: 'testing functionality'!

isSmallInteger
    ^true
! !
