"======================================================================
|
|   File autoloading mechanism
|
|   $Revision: 1.8.5$
|   $Date: 2000/12/27 10:45:49$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
| Written by Steve Byrne.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"

nil subclass: #Autoload
       instanceVariableNames: 'className fileName'
       classVariableNames: ''
       poolDictionaries: ''
       category: 'Examples-Useful tools'
!

Autoload comment:
'I am not a part of the normal Smalltalk kernel class system.  I provide the
ability to do late-loading or "on demand loading" of class definitions.
Through me, you can define any class to be loaded when any message is sent to
the class itself (such as to create an instance).' !


!Autoload class methodsFor: 'instance creation'!

class: classNameString from: fileNameString
    "Make Smalltalk automatically load the class named classNameString
     from fileNameString when needed"

    ^Autoload new autoload__InitClass: classNameString 
		  initFile: fileNameString
! !


!Autoload methodsFor: 'accessing'!

doesNotUnderstand: aMessage
    "Load the file, then reinvoke the method forwarding it to the
    newly loaded class."

    | s |
    Smalltalk removeKey: className.
    FileStream fileIn: fileName.
    ^aMessage reinvokeFor: (Smalltalk at: className
				      ifAbsent: [ ^Autoload error: 
'Autoloaded file should have defined class "', className, '" but didn''t' ])
! !



!Autoload methodsFor: 'private'!

autoload__InitClass: aClassName initFile: aFileName
    className := aClassName asSymbol.
    Smalltalk at: className put: self.
    fileName := aFileName.
! !
