/* PIPS version 1.01: Parallel Information Processing System 
   Copyright (C) 1994, 95, 96 Free Software Foundation, Inc.

This file is part of GNU PIPS.

GNU PIPS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU PIPS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU PIPS; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*/

/*
 * Name          : pips/src/pipsDataPerJob.c
 * Author        : Frank Heimes
 * Institution   : Imperial College of Science, Technology, and Medicine
 * Written on    : Thu Oct 13 21:36:52 WET DST 1994
 * Modified on   : 
 * Synopsis      : 
 *
 *   long pipsDataPerJob (ntask, granularity, lower, upper, items, njobs)
 *
 *   int ntask        IS   Number of tasks available for parallel
 *                         data processing (spawned by pipsTaskManager)
 *   int granularity  IS   A number to influence the number of data fragments
 *                         (jobs) generated.
 *   int lower        IS   A lower bound for the number of jobs
 *   int upper        IS   An upper bound for the number of jobs
 *   int *njobs       IS   The number of jobs to generate
 *
 * Description   : 
 *
 *   Calculates the 'optimal' number of jobs to distribute among the children.
 *   It will be at least 'lower' and at most 'upper'.
 *   The function returns the number of items per job.
 */

#include "pips.h"   /* PIPS system header file  */

#ifdef __STDC__

long pipsDataPerJob (int ntask, int granularity, int lower, int upper,
                      long items, int *njobs)

#else

pipsDataPerJob (ntask, granularity, lower, upper, items, njobs)
    int ntask;
    int granularity;
    int lower;
    int upper;
    long items;
    int *njobs;

#endif
{
/*
 * number of jobs to distribute
 */
  *njobs = ntask * granularity;

/*
 * Test njobs against the upper bound
 */
  if (*njobs > upper)
    *njobs = upper;

/*
 * Test njobs against the lower bound
 */
  if (*njobs < lower)
    *njobs = lower;

/*
 * number of items per job
 */
  items /= (*njobs);
  return (items);
} /* pipsDataPerJob */


/* end pipsDataPerJob.c */
