/*
* 
* PATTERN.H 
* Definitions for OCTAL's pattern/event system. 
*
* This software is distributed under the terms of the
* GNU General Public License (GPL). Read the included file
* COPYING for more information. 
* 
*/
#ifndef _pattern_h_
#define _pattern_h_ 

#include "octal.h"

// 
// TRACK TYPES
// order is important. don't mess with these 

enum { tk_normal, tk_mixer, tk_mixer_mono = 1, tk_mixer_stereo };


//
// TRACK STRUCTURE
//

typedef struct _track {
	param *c;		// cells
	param *current_values;	
	int type;	

	struct _track *next; 

} track;


//
// PATTERN STRUCTURE
// contains a list of normal tracks, 
// and possibly a list of pan/amp tracks
// 

typedef struct _pattern {
	int params_per_track; 
	int num_rows; 
  
	char name[32];

	track *normal; 			// track zero (always have >= 1)
	track *mixer;			// another list for amp+pan controls
	
} pattern; 


//
// PATTERN API
// does not expose existence of track

pattern* pt_create(int params_per_track, int num_rows);
void pt_destroy(pattern*); 
void pt_grab_current_values(pattern*, int);

void pt_add_track(pattern *p, int type);    
void pt_remove_track(pattern *p, int type); 

// these return -1 on failure

int pt_set_cell(pattern* p, int type, int track, int row, int col, param value); 
param pt_get_cell(pattern* p, int type, int track, int row, int col); 

// $$$ bridge function to ox_update() entire row of params 
// deal with patterns that change length


//
// TRACK API (pattern handles some of this)
//

track *tk_create(int params_per_track, int num_rows, int type);
void tk_destroy(track *t);






#endif /*_pattern_h_*/
/* $Source: /cvsroot/octal/octal/pattern.h,v $ */
