/*
* (C) 2000,2001 David O'Toole $Date: 2001/04/11 03:57:03 $
* $Revision: 1.2 $
* 
* engine digraph analysis / compilation
* 
* This software is distributed under the terms of the
* GNU General Public License (GPL). Read the included file
* COPYING for more information. 
* 
*/

#ifndef _mixer_h_
#define _mixer_h_ 

#include "engine.h"

typedef struct _mx_action {
  struct _mx_action *next; 
  int opcode;
  int a, b; 
} mx_action;


void mx_execute  (engine*,int,int);
void mx_add      (engine*,int,int);
void mx_remix    (engine*,int,int);
void mx_clear    (engine*,int,int);
void mx_finish   (engine*,int,int);

enum {mxc_execute, mxc_add,
      mxc_remix, mxc_clear, mxc_finish}; 

mx_action* mx_create(int opcode, int a, int b);
mx_action* mx_append(mx_action* listhead, mx_action* new);
int mx_do_action(engine*, mx_action*);
mx_action* mx_compile_digraph(engine* e, int machine_index, mx_action*); 
mx_action* mx_destroy(mx_action *listhead);
void mx_print_program(engine *e, mx_action *q);

#endif 

/* $Source: /cvsroot/octal/octal/mixer.h,v $ */
