/*
 * CONTROL_BOX.C
 * Implementations for control_box and machine_view
 *
 * I wrote this while listening to Orbital's "In Sides"
 * 
 */

#include <gtk/gtk.h>
#include <string.h>
#include <assert.h>
#include <stdio.h>
#include "control_box.h"

void cb_create(control_box **cbp, engine *subject, int machine_id, GtkWidget *parent_box)
{
	int i, nparams;
	GtkWidget *table, *label, *box, *tbar, *button, *sep;
	char buffer[100];
	machine *m;
	machine_type *mt;
	control_box *self;

	// DO NOTHING IF CONTROL BOX ALREADY EXISTS

	if (*cbp) return;

	// ALLOCATE AND CHECK MEMORY

	self = malloc(sizeof(control_box));
	assert(self);

	// STORE VALUE IN ITS HOME

	*cbp = self; 	

	printf("Inside cb_create(), subject = %p machine=%d\n", subject, machine_id);

	// GRAB RELEVANT DATA 

	pthread_mutex_lock(&subject->mutex);
		m = subject->machines[machine_id];
		strcpy(buffer, m->instance_name);
		mt = m->type;
	pthread_mutex_unlock(&subject->mutex);

	// INITIALIZE

	box = gtk_vbox_new (FALSE, 0);
	
	self->machine_id = machine_id;
	self->subject = subject;	
	self->track = 0;		// this is always safe

	self->dock = gtk_handle_box_new();	
	gtk_handle_box_set_handle_position(GTK_HANDLE_BOX(self->dock), GTK_POS_RIGHT);
	gtk_container_set_border_width(GTK_CONTAINER(self->dock), 4);

	// CREATE TOP BAR, CLOSE BUTTON

	tbar = gtk_hbox_new (FALSE, 1);
	label = gtk_label_new (buffer);
	button = gtk_button_new_with_label ("X");		// i'm cheap
	sep = gtk_hseparator_new();	

	gtk_box_pack_start (GTK_BOX(tbar), button, FALSE, FALSE, 0);
	gtk_box_pack_end (GTK_BOX(tbar), label, FALSE, FALSE, 0);
	gtk_signal_connect (GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(cb_delete_event_cb), (gpointer)cbp);

	// FIXME: POSSIBLY CREATE SLIDERS FOR CURRENT INPUTS AND "GLOBAL PARAMS"

	// CALL THE WIDGET BUILDER TO CREATE A WIDGET FOR EACH PARAM

	nparams = mt->num_params;
	table = gtk_table_new (nparams, 3, FALSE);	
	gtk_table_set_col_spacing (GTK_TABLE(table), 0, 3);

	for (i=0; i<nparams; i++)
		build_widget(self, machine_id, mt, i, table);
	
	// GLUE BOXES TOGETHER AT TOP LEVEL

	gtk_box_pack_start (GTK_BOX(box), tbar, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX(box), sep, FALSE, FALSE, 0);
	gtk_box_pack_end (GTK_BOX(box), table, FALSE, FALSE, 0);
		
	// PUT IT ALL IN THE PARENT AND DISPLAY

	gtk_container_add (GTK_CONTAINER(self->dock), box);
	gtk_box_pack_start (GTK_BOX(parent_box), self->dock, FALSE, FALSE, 1);
	gtk_widget_show_all(self->dock); 	
	
}


//
// Delete control box, null out its pointer,
// and remove it from the control bar

void cb_destroy(control_box **target) 
{
	control_box *self = *target;

	assert(self);
	gtk_widget_destroy(self->dock);
	free(self); 
	*target = 0; 
}


//
// GTK+ WIDGET BUILDER
// 

void build_widget(control_box *self, int machine_id, machine_type *mt, int i, GtkWidget *table)
{
	GtkWidget *name, *feedback, *slider; 		// slider
	GtkWidget *option, *menu, *item, *label;	// option
	GtkWidget *button;							// button
	int k; 
	char buf[1024];
	param_spec *ps = mt->param_specs + i;
	GtkObject *adj;

	// all widgets need a GtkAdjustment with certain data/signals attached
	// so that obi-wan will know how to retrieve it 

	adj = gtk_adjustment_new (ps->start, ps->min, ps->max, (float)((ps->max -
ps->min) / 250.0), 1.0, 0);

	printf ("build_widget %p %f %f (%f) %f\n", adj, ps->min, ps->max, (float)((ps->max -
ps->min) / 250.0), (GTK_ADJUSTMENT(adj))->step_increment);

	gtk_object_set_data (GTK_OBJECT(adj), "self", self);
	gtk_object_set_data (GTK_OBJECT(adj), "which_param", (gpointer)i);
	gtk_signal_connect (GTK_OBJECT(adj), "value-changed", cb_update_cb, NULL);
	
	// now build widgets based on the requested widget type

	switch (ps->widget) {

	case OX_WIDGET_SLIDER:

		slider = gtk_hscale_new (GTK_ADJUSTMENT(adj));
		gtk_scale_set_draw_value (GTK_SCALE(slider), 0);
		gtk_scale_set_digits (GTK_SCALE(slider), 5);
		name = gtk_label_new (ps->name);
		feedback = gtk_label_new ("  ...  ");
	
		// If the widget type needs interactive feedback, the "feedback" field must be set

		gtk_object_set_data (GTK_OBJECT(adj), "feedback", (gpointer)feedback);

		// place objects in destination table as we see fit...
		// this way things will line up better than not using a table
		// and just returning a GtkWidget*

		gtk_table_attach (GTK_TABLE(table), name,
			0, 1,
			i, i+1,
			GTK_FILL, GTK_FILL,
			0, 0);

		gtk_table_attach (GTK_TABLE(table), slider,
			1, 2, 
			i, i+1,
			GTK_FILL | GTK_EXPAND,
			GTK_FILL, 
			0, 0);

		gtk_table_attach (GTK_TABLE(table), feedback,
			2, 3,
			i, i+1, 
			GTK_FILL, GTK_FILL,
			0, 0);
	
	break; 


	case OX_WIDGET_OPTION:
	
		option = gtk_option_menu_new ();
		label = gtk_label_new(ps->name);
		menu = gtk_menu_new ();
		gtk_option_menu_set_menu (GTK_OPTION_MENU(option), GTK_WIDGET(menu));

		for (k = ps->min; k <= ps->max; k++) {
			mt->ox_desc (buf, i, k);		// get description for this parameter and value
			item = gtk_menu_item_new_with_label (buf);
			
			// attach field and signal with chosen value as user_data		
			// such that activating the menu item will cause the adjustment to get 
			// altered (see below) which will in turn cause the parameter to get updated

			gtk_object_set_data (GTK_OBJECT(item), "adjustment", (gpointer)adj);	// whom do we update? 
			gtk_signal_connect (GTK_OBJECT(item), "activate", GTK_SIGNAL_FUNC(cb_update_adjustment_cb), (gpointer)k); 	
			gtk_menu_append (GTK_MENU(menu), GTK_WIDGET(item));			
		}

		// pack option box into table

		gtk_table_attach (GTK_TABLE(table), label,
			0, 1,
			i, i+1,
			GTK_FILL, GTK_FILL,
			0, 0);

		gtk_table_attach (GTK_TABLE(table), option,
			1, 2, 
			i, i+1,
			GTK_FILL | GTK_EXPAND,
			GTK_FILL, 
			0, 0);

	break;
	
	case OX_WIDGET_BUTTON:
		
		button = gtk_button_new_with_label(ps->description);
		gtk_object_set_data (GTK_OBJECT(button), "adjustment", (gpointer)adj);
		gtk_signal_connect (GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(cb_update_adjustment_cb), NULL);
		label = gtk_label_new (ps->name);
	
		gtk_table_attach (GTK_TABLE(table), label,
			0, 1,
			i, i+1,
			GTK_FILL, GTK_FILL,
			0, 0);

		gtk_table_attach (GTK_TABLE(table), button,
			1, 2, 
			i, i+1,
			GTK_FILL | GTK_EXPAND,
			GTK_FILL, 
			0, 0);
	break;

	default:
		assert(0);

	}
}


//
// GTK+ EVENT CALLBACKS
//


// AUXILIARY CALLBACK FOR WIDGETS THAT DON'T AUTOMATICALLY UPDATE THEIR ADJUSTMENTS

void cb_update_adjustment_cb (GtkObject *object, gpointer data)
{
	param value = (int)data;  // FIXME: losing precision?
	GtkAdjustment *adj = (GtkAdjustment*) gtk_object_get_data( GTK_OBJECT(object), "adjustment");

	assert(adj);

	printf("cb_update_adjustment with %p, %p, %f\n", object, adj, value);

	// we must do this instead. the above doesn't actually update the 
	// adjustment for triggers.

	adj->value = value;
	gtk_adjustment_value_changed(adj);
}


// CALLBACK FOR WIDGET TYPES THAT USE ADJUSTMENTS
// I realize this one isn't exactly light reading. Will probably get cleaned up. 

void cb_update_cb(GtkAdjustment *adj, gpointer unused)
{
	control_box *self = gtk_object_get_data (GTK_OBJECT(adj), "self");
	int track = self->track;
	int pm = (int) gtk_object_get_data (GTK_OBJECT(adj), "which_param");
	GtkObject *feedback = gtk_object_get_data(GTK_OBJECT(adj), "feedback");	
	param value = adj->value;
	char buffer[100];	
	machine_type *mt;
	
	printf("cb_update with value %f, step_increment as %f \n", value,
adj->step_increment);

	// update parameters
	
	pthread_mutex_lock(&self->subject->mutex);		
 		mt = en_get_type_from_index(self->subject, self->machine_id);
		en_event(self->subject, self->machine_id, track, pm, value);
	pthread_mutex_unlock(&self->subject->mutex);

	// if adjustment had "feedback" data attached, then write to that label

	if (feedback) {
		mt->ox_desc(buffer, pm, value);	
		gtk_label_set_text(GTK_LABEL(feedback), buffer); 
	}
}

gboolean cb_delete_event_cb(GtkWidget *widget, gpointer data)
{
	control_box **self = data;

	printf("cb_delete_event_cb with %p, %p\n", widget, data);
	cb_destroy(self);
	return FALSE;
}








