/* 
   NSFontManager.h

   Manages system and user fonts

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Scott Christley <scottc@net-community.com>
   Date: 1996
   
   This file is part of the GNUstep GUI Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#ifndef _GNUstep_H_NSFontManager
#define _GNUstep_H_NSFontManager

#include <Foundation/NSObject.h>

@class NSString;
@class NSArray;

@class NSFont;
@class NSMenu;
@class NSFontPanel;

typedef unsigned int NSFontTraitMask;

enum {
  NSItalicFontMask = 1,
  NSBoldFontMask = 2,
  NSUnboldFontMask = 4,
  NSNonStandardCharacterSetFontMask = 8,
  NSNarrowFontMask = 16,
  NSExpandedFontMask = 32,
  NSCondensedFontMask = 64,
  NSSmallCapsFontMask = 128,
  NSPosterFontMask = 256,
  NSCompressedFontMask = 512,
  NSUnitalicFontMask = 1024
};

@interface NSFontManager : NSObject
{
  // Attributes
  id delegate;
  SEL action;
  NSFont *selected_font;
  NSArray *fontsList;
  NSMenu *font_menu;
}

//
// Managing the FontManager
//
+ (void)setFontManagerFactory:(Class)classId;
+ (void)setFontPanelFactory:(Class)classId;
+ (NSFontManager *)sharedFontManager;

//
// Converting Fonts
//
- (NSFont *)convertFont:(NSFont *)fontObject;
- (NSFont *)convertFont:(NSFont *)fontObject
	       toFamily:(NSString *)family;
- (NSFont *)convertFont:(NSFont *)fontObject
		 toFace:(NSString *)typeface;
- (NSFont *)convertFont:(NSFont *)fontObject
	    toHaveTrait:(NSFontTraitMask)trait;
- (NSFont *)convertFont:(NSFont *)fontObject
	 toNotHaveTrait:(NSFontTraitMask)trait;
- (NSFont *)convertFont:(NSFont *)fontObject
		 toSize:(float)size;
- (NSFont *)convertWeight:(BOOL)upFlag
		   ofFont:(NSFont *)fontObject;
- (NSFont *)fontWithFamily:(NSString *)family
		    traits:(NSFontTraitMask)traits
		    weight:(int)weight
		      size:(float)size;

//
// Setting and Getting Parameters
//
- (SEL)action;
- (NSArray *)availableFonts;
- (NSMenu *)fontMenu:(BOOL)create;
- (NSFontPanel *)fontPanel:(BOOL)create;
- (void)orderFrontFontPanel:(id)sender;
- (BOOL)isEnabled;
- (BOOL)isMultiple;
- (NSFont *)selectedFont;
- (void)setAction:(SEL)aSelector;
- (void)setEnabled:(BOOL)flag;
- (void)setFontMenu:(NSMenu *)newMenu;
- (void)setSelectedFont:(NSFont *)fontObject
	     isMultiple:(BOOL)flag;
- (NSFontTraitMask)traitsOfFont:(NSFont *)fontObject;
- (int)weightOfFont:(NSFont *)fontObject;

//
// Target and Action Methods
//
- (BOOL)sendAction;

//
// Assigning a Delegate
//
- (id)delegate;
- (void)setDelegate:(id)anObject;

//
// Methods Implemented by the Delegate
//
- (BOOL)fontManager:(id)sender willIncludeFont:(NSString *)fontName;

@end

@interface NSFontManager (GNUstepBackend)

//
// Have the backend determine the fonts and families available
//
- (void)enumerateFontsAndFamilies;

@end

#endif // _GNUstep_H_NSFontManager
