/*
   PXKMenu.m

   Copyright (C) 1996 Free Software Foundation, Inc.

   A completely rewritten version of the original source by Scott Christley.
   Author: Ovidiu Predescu <ovidiu@net-community.com>
   Date: May 1997
   Author:  Felipe A. Rodriguez <far@ix.netcom.com>
   Date: July 1998
   
   This file is part of the GNUstep GUI X/GPS Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#include <config.h>
#include <stdlib.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include <gnustep/xdps/NSDPSContext.h>
#include <Foundation/NSDebug.h>
#include <AppKit/NSFont.h>
#include <AppKit/NSMenuView.h>
#include <AppKit/PSOperators.h>

@interface	PXKMenuWindow : NSMenuWindow
@end

@implementation PXKMenuWindow

- (BOOL) canBecomeMainWindow
{
  return NO;
}

- (BOOL) canBecomeKeyWindow
{
  return NO;
}

- (void) initDefaults
{
  [super initDefaults];
  menu_exclude = YES;           // Don't show in windows menu.
  window_level = NSSubmenuWindowLevel;
  is_released_when_closed = NO;
}

- (id) initWithContentRect: (NSRect)contentRect
		 styleMask: (unsigned int)aStyle
		   backing: (NSBackingStoreType)bufferingType
		     defer: (BOOL)flag
		    screen: (NSScreen*)aScreen
{
  XSetWindowAttributes winattrs;
  unsigned long valuemask;

  self = [super initWithContentRect: contentRect
			  styleMask: aStyle
			    backing: bufferingType
			      defer: flag
			     screen: aScreen];

  valuemask = (CWSaveUnder|CWOverrideRedirect);
  winattrs.save_under = True;
  winattrs.override_redirect = True;
  XChangeWindowAttributes ([NSDPSContext currentXDisplay], [self xWindow],
                            valuemask, &winattrs);
  [[NSApplication sharedApplication] removeWindowsItem: self];

  return self;
}

- (BOOL) worksWhenModal
{
  return YES;
}

@end
