/* 
   PXKImage.m

   NSImage for GNUstep GUI X/DPS Backend.

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Adam Fedor <fedor@colorado.edu>
   Date: Feb 1996
   
   This file is part of the GNUstep GUI X/DPS Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include "config.h"
#include <AppKit/NSColor.h>
#include <gnustep/xdps/NSDPSContext.h>

@interface PXKImage : NSImage
@end

@implementation PXKImage

- (BOOL)drawRepresentation: (NSImageRep *)imageRep inRect: (NSRect)rect
{
  // Draw the background color
  if (!_flags.scalable) 
    {
      [_color set];
      NSRectFill(rect);
    }
  else
    {
      NSRect r = NSMakeRect(0, 0, rect.size.width, rect.size.height);
      [_color set];
      NSRectFill(r);
    }
  
  return [super drawRepresentation: imageRep inRect: rect];
}

- (Class) classForCoder: aCoder
{
  if ([self class] == [PXKImage class])
    return [super class];
  return [self class];
}

@end
