/*
   PXKMenu.h

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Ovidiu Predescu <ovidiu@net-community.com>
   Date: May 1997
   A completely rewritten version of the original source by Scott Christley.
   
   This file is part of the GNUstep GUI X/DPS Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __gnustep_xdps_PXKMenu_h__
#define __gnustep_xdps_PXKMenu_h__

#include <AppKit/NSMenu.h>

@class NSString;

@class NSEvent;
@class PXKMenuWindow;
@class PXKMenuWindowTitleView;

extern NSString* NSMenuLocationsKey;

@interface PXKMenu : NSMenu
- (PXKMenuWindow*)menuWindow;
- (PXKMenuWindowTitleView*)titleView;
- (void)windowBecomeTornOff;
- (BOOL)hasAnAssociatedTornOffMenu;
@end


@interface PXKMenuMatrix : NSMenuMatrix
- (void)mouseDown:(NSEvent*)event;
@end


#endif /* __gnustep_xdps_PXKMenu_h__ */
