#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2009 Free Software Foundation
#
# FILE:
# GNParser.py
#
# DESCRIPTION:
# Class that contains a sax based xml processor for GNUe Nav
#
# NOTES:
#

from gnue.common.definitions import GParser

import copy, types
from gnue.common.formatting import GTypecast






########
########  Please keep this file neat !!!
########






#######################################################
# This method loads a form from an XML file and returns
# a GNProcesses object.  If initialize is 1 (default),
# then the process def is initialized and ready to go.
#
# (initialize=0 is currently not used -- will probably
#  be used in the Designer package where we will
#  not want the loaded form to connect to databases, etc)
#######################################################

def loadProcesses(buffer, initialize=1):
  return GParser.loadXMLObject (buffer, xmlProcessHandler, 'GNProcesses', 'processes',
           initialize, attributes={})


xmlElements = None


def getXMLelements():

  global xmlElements

  if xmlElements == None:
    import GNObjects

    xmlElements = {
      'processes': {
         'BaseClass': GNObjects.GNProcesses,
#         'Required': 1,
         'SingleInstance': 1,
         'Attributes': {
            'title': {
               'Typecast': GTypecast.text,
               'Default': 'Untitled Menu' } },
         'ParentTags': None },

      'process': {
         'BaseClass': GNObjects.GNProcess,
         'Attributes': {
            'id': {
#               'Required': 1,
               'Unique': 1,
               'Typecast': GTypecast.name },
            'title': {
               'Typecast': GTypecast.text } },
         'ParentTags': ('processes','process') },

      'step': {
         'BaseClass': GNObjects.GNStep,
         'Attributes': {
            'id': {
#               'Required': 1,
               'Unique': 1,
               'Typecast': GTypecast.name },
            'type': {
               'Required': 1,
               'ValueSet': {
                 'app': {},
                 'form': {},
                 'report': {} },
               'Typecast': GTypecast.name },
            'location': {
               'Typecast': GTypecast.text },
            'title': {
               'Typecast': GTypecast.text } },
         'ParentTags': ('process','step') },

      'parameter': {
         'BaseClass': GNObjects.GNParameter,
         'Attributes': {
            'name': {
               'Required': 1,
               'Typecast': GTypecast.name },
            'value': {
               'Unique': 1,
               'Typecast': GTypecast.text } },
         'ParentTags': ('step',) },

      'description': {
         'BaseClass': GNObjects.GNDescription,
         'Attributes': {},
         'MixedContent': 1,
         'KeepWhitespace': 1,
         'UsableBySiblings': 1,
##         'SingleInstance': 1,
         'ParentTags': ('processes', 'process', 'step') },

    }



    #
    # Add importable elements
    # If an object needs to be importable,
    # simply add its tag name to the tuple below
    # and make sure it has a "name" attribute
    # (otherwise we don't know how to reference
    # it in the imported file).
    #
    for key in ('process',):
      name = "import-%s" % key
      copy._deepcopy_dispatch[types.FunctionType] = copy._deepcopy_atomic
      copy._deepcopy_dispatch[types.ClassType] = copy._deepcopy_atomic
      copy._deepcopy_dispatch[type(int)] = copy._deepcopy_atomic

      p = copy.deepcopy(xmlElements[key])
      p['BaseClass'] = GNObjects.GNImportItem
      p['Attributes']['library'] = {
         'Required': 1,
         'Typecast': GTypecast.name }
      p['MixedContent'] = 0
      p['Required'] = 0

      xmlElements[name] = p

  return GParser.buildImportableTags('schema',xmlElements)


#######################################################
#
# xmlFormsHandler
#
# This class is called by the XML parser to
# process the xml file.
#
#######################################################

class xmlProcessHandler (GParser.xmlHandler):
  def __init__(self):

    GParser.xmlHandler.__init__(self)

    self.xmlElements = getXMLelements()


