# GNU Enterprise Forms - Win32 UI Driver - UI specific base dialog
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: dialog.py 9956 2009-10-11 18:54:57Z reinhard $

import sys
import struct

import win32api
import win32gui
import win32con
import commctrl

from gnue.common.apps import i18n, errors
from gnue.forms.uidrivers.win32.common import textEncode

g_registeredClass = 0

BUTTON = 0x0080


class BaseDialog:

    def __init__ (self, parent, title, cancel = False, ok = True):
        win32gui.InitCommonControls()
        self.hinst = win32api.GetModuleHandle(None)
        self.parent = parent
    
        self.message_map = {
                win32con.WM_COMMAND: self.OnCommand,
                win32con.WM_INITDIALOG: self.OnInitDialog,
                win32con.WM_CLOSE: self.OnClose,
                }

        dlgClassName = self._RegisterWndClass()
    
        style = win32con.WS_POPUP | win32con.WS_VISIBLE | win32con.WS_CAPTION | \
                win32con.DS_SETFONT | win32con.WS_SYSMENU | win32con.DS_MODALFRAME
    
        self.template = [ [textEncode(title), (0, 0, 120, 20), style, None, \
                          (8, "MS Sans Serif"), None, dlgClassName], ]
    
        if ok:
            self.template.append ([BUTTON, _("Ok"), win32con.IDOK, (0, 0, 56, 15),
              win32con.WS_CHILD | win32con.WS_VISIBLE | \
              win32con.WS_TABSTOP | win32con.BS_DEFPUSHBUTTON])
        if cancel:
            self.template.append ([BUTTON, _("Cancel"), win32con.IDCANCEL, (60, 0, 56, 15),
              win32con.WS_CHILD | win32con.WS_VISIBLE | \
              win32con.WS_TABSTOP | win32con.BS_PUSHBUTTON])
      
      
    def DoModal(self):
        self.oldfocus = win32gui.GetFocus()
        return win32gui.DialogBoxIndirect(self.hinst, self.template, self.parent, self.message_map)
    
    
    def OnInitDialog(self, hwnd, msg, wparam, lparam):
        self.hwnd = hwnd
    
    def OnClose(self, hwnd, msg, wparam, lparam):
        win32gui.EndDialog(hwnd, 1)
        win32gui.SetFocus(self.oldfocus)
    

    def Destroy(self):
        pass
    

    def OnCommand(self, hwnd, msg, wparam, lparam):
        id = win32api.LOWORD(wparam)
        if id == win32con.IDOK:
            win32gui.EndDialog(hwnd, 1)
            win32gui.SetFocus(self.oldfocus)
      
        elif id == win32con.IDCANCEL:
            win32gui.EndDialog(hwnd, 0)
            win32gui.SetFocus(self.oldfocus)

          
    def _RegisterWndClass(self):
        className = "GNUe dialog"
        global g_registeredClass
    
        try:
            icon = win32gui.LoadImage(0, sys.prefix+'\py.ico', win32con.IMAGE_ICON,
                                      0, 0, win32con.LR_LOADFROMFILE | win32con.LR_DEFAULTSIZE)
        except:
            icon = win32gui.LoadIcon(0, win32con.IDI_APPLICATION)

        if not g_registeredClass:
            message_map = {}
            wc = win32gui.WNDCLASS()
            wc.SetDialogProc() # Make it a dialog class.
            self.hinst = wc.hInstance = win32api.GetModuleHandle(None)
            wc.lpszClassName = className
            wc.style = win32con.CS_VREDRAW | win32con.CS_HREDRAW
            wc.hCursor = win32gui.LoadCursor( 0, win32con.IDC_ARROW )
#      wc.hIcon = win32gui.LoadIcon(0, win32con.IDI_APPLICATION)
            wc.hIcon = icon
            wc.hbrBackground = win32con.COLOR_WINDOW
            wc.lpfnWndProc = message_map # could also specify a wndproc.
            wc.cbWndExtra = win32con.DLGWINDOWEXTRA + struct.calcsize("Pi")
            classAtom = win32gui.RegisterClass(wc)
            g_registeredClass = 1
        return className
    
    
if __name__ == '__main__':
    dialog = BaseDialog('MyDialog', cancel=True)
    dialog.DoModal()
