# GNU Enterprise Forms - QT3 UI driver - Buttons
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: button.py 9956 2009-10-11 18:54:57Z reinhard $

from PyQt4 import Qt as qt

from gnue.forms.uidrivers.qt4.widgets._base import UIHelper

__all__ = ['UIButton']

# =============================================================================
# Implementation of the <button> tag
# =============================================================================

class UIButton(UIHelper):
    """
    Implementation of the <button> tag
    """

    # -------------------------------------------------------------------------
    # Create the button widget
    # -------------------------------------------------------------------------

    def _create_widget_(self, event, spacer):
        """
        Create the button widget
        """

        owner = self.getParent()
        if self.in_grid:
            parent = owner._get_cell(self, spacer)
        else:
            parent = event.container

        self.widget = Button(parent, self)

        if self.in_grid:
            self.widget._gnue_label_ = None

        owner.add_widgets(self, spacer)

        return self.widget


    # -------------------------------------------------------------------------
    # Enable/disable this button
    # -------------------------------------------------------------------------

    def _ui_enable_(self, index):
        self.widgets[index].setEnabled(True)

    # -------------------------------------------------------------------------

    def _ui_disable_(self, index):
        self.widgets[index].setEnabled(False)


# =============================================================================
# QT Button class 
# =============================================================================

class Button(qt.QPushButton):
    """
    Descendant of a qt.QPushButton which implements the clicked event to fire
    the corresponding even of the GFButton instance
    """

    # -------------------------------------------------------------------------
    # Constructor
    # -------------------------------------------------------------------------

    def __init__(self, parent, ui_widget):

        qt.QPushButton.__init__(self, ui_widget._gfObject.label, parent)

        self.connect(self, qt.SIGNAL('clicked()'), self.__on_clicked)
        self.ui_widget = ui_widget

    # -------------------------------------------------------------------------
    # Slot implementations
    # -------------------------------------------------------------------------

    def __on_clicked(self):

        # FIXME: _event_set_focus only needed if the button was not focussed
        # before anyway. Maybe use focusInEvent like for entries?
        # Does the GF focus move to this button correctly if it is only
        # focussed with the mouse but not clicked?
        self.ui_widget._gfObject._event_set_focus(self.ui_widget.widgets.index(
                self))
        self.ui_widget._gfObject._event_fire()


# =============================================================================
# Configuration
# =============================================================================

configuration = {
  'baseClass': UIButton,
  'provides' : 'GFButton',
  'container': 0,
}
