/* libc-malloc.h - decls for PIW replacements for standard malloc functions.
 *
 * author(s): Tom Lord
 ****************************************************************
 * Copyright (C) 1998 UUNET Technologies, Inc.
 *
 * See the file "COPYING.PIW" for further information
 * about the copyright status of this work.
 */

#ifndef INCLUDE__PIW__LIBC_MALLOC_H
#define INCLUDE__PIW__LIBC_MALLOC_H



#include "hackerlab/os/stddef.h"



/* malloc_options is provided for link compatability with some versions
 * of the C library (e.g. FreeBSD 3.0) but is not meaningful for
 * this implementation.
 */
extern char * malloc_options;

/* valloc, reallocf and cfree are not standard, but are provided for link
 * compatability with some versions of the C library.
 */

/* automatically generated __STDC__ prototypes */
extern void * malloc (size_t n_bytes);
extern void * calloc (size_t n_items, size_t sizeof_item);
extern void * valloc (size_t n_bytes);
extern void * realloc (void * block, size_t n_bytes);
extern void * reallocf (void * block, size_t n_bytes);
extern void free (void * block);
extern void cfree (void * block);
#endif  /* INCLUDE__PIW__LIBC_MALLOC_H */
