/* link-tree.c:
 *
 ****************************************************************
 * Copyright (C) 2003 Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "hackerlab/char/str.h"
#include "hackerlab/fs/file-names.h"
#include "hackerlab/vu/safe.h"
#include "tla/libfsutils/dir-listing.h"
#include "tla/libfsutils/copy-file.h"
#include "tla/libfsutils/link-target.h"
#include "tla/libfsutils/link-tree.h"



void
build_link_tree (t_uchar * from, t_uchar * to)
{
  struct stat statb;

  safe_lstat (from, &statb);

  if (S_ISDIR (statb.st_mode))
    {
      rel_table contents = 0;
      int x;

      safe_mkdir (to, statb.st_mode & (S_IRWXU | S_IRWXG | S_IRWXO));
      safe_chmod (to, statb.st_mode & (S_IRWXU | S_IRWXG | S_IRWXO));

      contents = directory_files (from);

      for (x = 0; x < rel_n_records (contents); ++x)
        {
          if (str_cmp (".", contents[x][0]) && str_cmp ("..", contents[x][0]))
            {
              t_uchar * sub_from = 0;
              t_uchar * sub_to = 0;

              sub_from = file_name_in_vicinity (0, from, contents[x][0]);
              sub_to = file_name_in_vicinity (0, to, contents[x][0]);

              build_link_tree (sub_from, sub_to);

              lim_free (0, sub_from);
              lim_free (0, sub_to);
            }
        }

      rel_free_table (contents);
    }
  else if (S_ISLNK (statb.st_mode))
    {
      copy_symlink (from, to);
    }
  else
    {
      safe_link (from, to);
    }
}



/* tag: Tom Lord Fri May 30 15:11:13 2003 (link-tree.c)
 */
