/* write-barrier-breakpoints.c -
 *
 ****************************************************************
 * Copyright (C) 2000 Tom Lord
 * 
 * See the file "COPYING.PIW" for further information about
 * the copyright and warranty status of this work.
 */


#include "hackerlab/piw/gdb.h"
#include "hackerlab/piw-malloc/write-barrier-breakpoints.h"



/*(c piw_write_barrier_breakpoint)
 * void * piw_write_barrier_breakpoint (void * addr, int length);
 * 
 * If write barriers are active this breakpoint is reached
 * when a PIW write barrier detects an imminent stray write.  `length'
 * bytes at `addr' are about to be written, but that region includes
 * location(s) in the malloc arena which are not part of any allocated
 * region.
 * 
 */
void *
piw_write_barrier_breakpoint (void * addr, int length)
{
  /*c
   * void * piw_write_barrier_breakpoint (void * addr, int length);
   *
   * This breakpoint is reached when a PIW write barrier detects
   * an imminent stray write.   `length' bytes at `addr' are about
   * to be written, but that region includes location(s) in the malloc
   * arena which are not part of any allocated region.
   */
  piw_msg_breakpoint ("write to illegal location detected by write barrier");
  return addr;
}
