#  $Id: 2um-dvi.awk 0.04 1996/06/26 00:00:04 tom Exp $
#
#  2um-dvi.awk:  Very simple and silly `AWK' script for converting
#                  "a "o "u "s "A "O "U  character sequences found
#                  in the German `gcal.texi' file to sequences, the
#                  TeX formatter should be able to typeset as German
#                  "Umlaute" characters.
#
#
#  Public domain.
#
/@chapter|@section|@subsection|@subsubsection/ {
  len = length($0)
  tmptxt = ""
  if ($0 ~ /"/)
   {
     found = 0
     for (i=1; i <= len; i++)
      {
        tmpchr = substr($0, i, 1)
        if (tmpchr == "\"")
         {
           if (found == 1)
            {
              found = 0
              tmptxt = tmptxt tmpchr tmpchr
            }
           else
             found = 1
         }
        else
         {
           if (found == 1)
            {
              found = 0
              if (tmpchr == "a")
                tmptxt = tmptxt "ae"
              else
               {
                 if (tmpchr == "o")
                   tmptxt = tmptxt "oe"
                 else
                  {
                    if (tmpchr == "u")
                      tmptxt = tmptxt "ue"
                    else
                     {
                       if (tmpchr == "s")
                         tmptxt = tmptxt "ss"
                       else
                        {
                          if (tmpchr == "A")
                            tmptxt = tmptxt "Ae"
                          else
                           {
                             if (tmpchr == "O")
                               tmptxt = tmptxt "Oe"
                             else
                              {
                                if (tmpchr == "U")
                                  tmptxt = tmptxt "Ue"
                                else
                                  tmptxt = tmptxt "\"" tmpchr
                              }
                           }
                        }
                     }
                  }
               }
            }
           else
             tmptxt = tmptxt tmpchr
         }
      }
     if (found == 1)
       print tmptxt tmpchr
     else
       print tmptxt
   }
  else
    print $0
  next
}
#
# Main block.
#
{
  len = length($0)
  tmptxt = ""
  if ($0 ~ /"/)
   {
     found = 0
     for (i=1; i <= len; i++)
      {
        tmpchr = substr($0, i, 1)
        if (tmpchr == "\"")
         {
           if (found == 1)
            {
              found = 0
              tmptxt = tmptxt tmpchr tmpchr
            }
           else
             found = 1
         }
        else
         {
           if (found == 1)
            {
              found = 0
              if (tmpchr == "a")
                tmptxt = tmptxt "@\"a"
              else
               {
                 if (tmpchr == "o")
                   tmptxt = tmptxt "@\"o"
                 else
                  {
                    if (tmpchr == "u")
                      tmptxt = tmptxt "@\"u"
                    else
                     {
                       if (tmpchr == "s")
                        {
                          if (i == len)
                            tmptxt = tmptxt "@ss "
                          else
                           {
                             if (substr($0, i+1, 1) == " ")
                               tmptxt = tmptxt "@ss@ "
                             else
                               tmptxt = tmptxt "@ss "
                           }
                        }
                       else
                        {
                          if (tmpchr == "A")
                            tmptxt = tmptxt "@\"A"
                          else
                           {
                             if (tmpchr == "O")
                               tmptxt = tmptxt "@\"O"
                             else
                              {
                                if (tmpchr == "U")
                                  tmptxt = tmptxt "@\"U"
                                else
                                  tmptxt = tmptxt "\"" tmpchr
                              }
                           }
                        }
                     }
                  }
               }
            }
           else
             tmptxt = tmptxt tmpchr
         }
      }
     if (found == 1)
       print tmptxt tmpchr
     else
       print tmptxt
   }
  else
    print $0
}
