/* glptext.h */

/*----------------------------------------------------------------------
-- Copyright (C) 2000, 2001, 2002 Andrew Makhorin <mao@mai2.rcnet.ru>,
--               Department for Applied Informatics, Moscow Aviation
--               Institute, Moscow, Russia. All rights reserved.
--
-- This file is a part of GLPK (GNU Linear Programming Kit).
--
-- GLPK is free software; you can redistribute it and/or modify it
-- under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2, or (at your option)
-- any later version.
--
-- GLPK is distributed in the hope that it will be useful, but WITHOUT
-- ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
-- or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public
-- License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with GLPK; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
-- 02111-1307, USA.
----------------------------------------------------------------------*/

#ifndef _GLPTEXT_H
#define _GLPTEXT_H

#define close_text            glp_close_text
#define open_text             glp_open_text
#define scan_token            glp_scan_token

typedef struct TEXT TEXT;

struct TEXT
{     /* text stream */
      void *fp; /* FILE *fp; */
      /* stream assigned to an input text file */
      char *file;
      /* name of the input text file */
      int line;
      /* number of the current text line */
      int c;
      /* the current character or EOF */
      int token;
      /* the current token: */
#define T_EOF  0  /* end-of-file */
#define T_NAME 1  /* symbolic name (identifier) */
#define T_INT  2  /* integer constant */
#define T_REAL 3  /* real (floating point) constant */
#define T_STR  4  /* character string (literal) */
#define T_SPEC 5  /* special character (delimiter) */
      int len;
      /* length of the current token (0 to 255) */
      char image[255+1];
      /* value (image) of the current token */
      int t_int;
      /* converted value of the integer constant */
      double t_real;
      /* converted value of the real constant */
      int err;
      /* error count */
};

extern TEXT *open_text(char *fname);
/* open text stream */

extern void scan_token(TEXT *text);
/* scan the next token from text stream */

extern void close_text(TEXT *text);
/* close text stream */

#endif

/* eof */
