/* newsamp.c */

#include <stdio.h>
#include <stdlib.h>
#include "glpk.h"

int main(void)
{     LPX *lp;
      int ndx[1+3];
      double val[1+3];
      double Z, x1, x2, x3;

s1:   lp = lpx_create_prob();
s2:   lpx_set_prob_name(lp, "sample");

s3:   lpx_add_rows(lp, 3);

s4:   lpx_set_row_name(lp, 1, "p");
s5:   lpx_set_row_bnds(lp, 1, LPX_UP, 0.0, 100.0);
s6:   lpx_set_row_name(lp, 2, "q");
s7:   lpx_set_row_bnds(lp, 2, LPX_UP, 0.0, 600.0);
s8:   lpx_set_row_name(lp, 3, "r");
s9:   lpx_set_row_bnds(lp, 3, LPX_UP, 0.0, 300.0);

s10:  lpx_add_cols(lp, 3);

s11:  lpx_set_col_name(lp, 1, "x1");
s12:  lpx_set_col_bnds(lp, 1, LPX_LO, 0.0, 0.0);
s13:  lpx_set_col_name(lp, 2, "x2");
s14:  lpx_set_col_bnds(lp, 2, LPX_LO, 0.0, 0.0);
s15:  lpx_set_col_name(lp, 3, "x3");
s16:  lpx_set_col_bnds(lp, 3, LPX_LO, 0.0, 0.0);

s17:  ndx[1] = 1,   ndx[2] = 2,   ndx[3] = 3;
s18:  val[1] = 1.0, val[2] = 1.0, val[3] = 1.0;
s19:  lpx_set_mat_row(lp, 1, 3, ndx, val);
s20:  ndx[1] = 3,   ndx[2] = 2,   ndx[3] = 1;
s21:  val[1] = 5.0, val[2] = 4.0, val[3] = 10.0;
s22:  lpx_set_mat_row(lp, 2, 3, ndx, val);
s23:  ndx[1] = 1,   ndx[2] = 2,   ndx[3] = 3;
s24:  val[1] = 2.0, val[2] = 2.0, val[3] = 6.0;
s25:  lpx_set_mat_row(lp, 3, 3, ndx, val);

s26:  lpx_set_obj_dir(lp, LPX_MAX);

s27:  lpx_set_col_coef(lp, 1, 10.0);
s28:  lpx_set_col_coef(lp, 2, 6.0);
s29:  lpx_set_col_coef(lp, 3, 4.0);

s30:  lpx_simplex(lp);

s31:  Z = lpx_get_obj_val(lp);
s32:  lpx_get_col_info(lp, 1, NULL, &x1, NULL);
s33:  lpx_get_col_info(lp, 2, NULL, &x2, NULL);
s34:  lpx_get_col_info(lp, 3, NULL, &x3, NULL);

s35:  printf("\nZ = %g; x1 = %g; x2 = %g; x3 = %g\n", Z, x1, x2, x3);

s36:  lpx_delete_prob(lp);

      return 0;
}

/* eof */
