/* glprsm/btran.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glprsm.h"

/*----------------------------------------------------------------------
-- btran - perform backward transformation.
--
-- *Synopsis*
--
-- #include "glprsm.h"
-- void btran(RSM *rsm, double u[]);
--
-- *Description*
--
-- The btran routine performs backward transformation (BTRAN) of the
-- vector u using some representation of the basis matrix.
--
-- This operation means solving the system B'*u' = u, where B is a
-- matrix transposed to the current basis matrix B, u is the given
-- vector which should be transformed, u' is the resultant vector.
--
-- On entry the array u should contain elements of the vector u in
-- locations u[1], u[2], ..., u[m], where m is order of the matrix B.
-- On exit this array contains elements of the vector u' in the same
-- locations. */

void btran(RSM *rsm, double u[])
{     if (rsm->pfi != NULL)
         pfi_btran(rsm->pfi, u);
      else if (rsm->rfi != NULL)
         rfi_btran(rsm->rfi, u);
      else if (rsm->afi != NULL)
         afi_btran(rsm->afi, u);
      else if (rsm->ufi != NULL)
         ufi_btran(rsm->ufi, u);
      else
         insist(rsm != rsm);
      return;
}

/* eof */
