/* glpapi/glp_find_col.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glpapi.h"

/*----------------------------------------------------------------------
-- glp_find_col - find column by name.
--
-- *Synopsis*
--
-- #include "glpk.h"
-- int glp_find_col(LPI *lp, char *name);
--
-- *Description*
--
-- The routine glp_find_col finds a column that has the given symbolic
-- name.
--
-- *Complexity*
--
-- The time complexity is O(log n'), where n' is number of named columns
-- in the column list.
--
-- *Returns*
--
-- If a column with the given name has been found, the routine returns
-- its sequential number. Otherwise, the routine returns zero. */

int glp_find_col(LPI *lp, char *name)
{     AVLNODE *node;
      STR *key;
      if (name == NULL || glp_check_name(name))
         fault("glp_find_col: invalid column name");
      key = create_str(lp->str_pool);
      set_str(key, name);
      node = find_by_key(lp->col_tree, key);
      delete_str(key);
      return node == NULL ? 0 : ((LPICOL *)node->link)->seqn;
}

/* eof */
