/* glpimg/set_pixel.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glpimg.h"

/*----------------------------------------------------------------------
-- set_pixel - set pixel to current color index.
--
-- *Synopsis*
--
-- #include "glpimg.h"
-- void set_pixel(IMG *img, int x, int y);
--
-- *Description*
--
-- The set_pixel routine sets the pixel of the raster image which has
-- relative coordinates (x,y) to the current color index.
--
-- If the pixel (x,y) is out of the clipping region, the routine does
-- nothing. */

void set_pixel(IMG *img, int x, int y)
{     /* convert to absolute coordinates */
      x += img->x0, y += img->y0;
      /* take into account the clipping region */
      if (img->x1 <= x && x <= img->x2 && img->y1 <= y && y <= img->y2)
         set_imgval(img, x, y, img->color);
      return;
}

/* eof */
