/* glpapi/glp_get_num_bin.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glpapi.h"

/*----------------------------------------------------------------------
-- glp_get_num_bin - determine number of binary columns.
--
-- *Synopsis*
--
-- #include "glpk.h"
-- int glp_get_num_bin(LPI *lp);
--
-- *Complexity*
--
-- The time complexity is O(n), where n is total number of columns in
-- the problem.
--
-- *Returns*
--
-- The routine glp_get_num_bin returns number of columns that marked as
-- integer and have zero lower bound and unity upper bound. */

int glp_get_num_bin(LPI *lp)
{     int count = 0, j;
      for (j = 1; j <= lp->n; j++)
      {  if (lp->col[j]->kind == 'I' && lp->col[j]->type == 'D' &&
             lp->col[j]->lb == 0.0 && lp->col[j]->ub == 1.0) count++;
      }
      return count;
}

/* eof */
