/* glpset/insist.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include "glpset.h"

/*----------------------------------------------------------------------
-- insist - check for logical condition.
--
-- *Synopsis*
--
-- #include "glpset.h"
-- void insist(int expr);
--
-- The insist macro checks for logical condition specified by the
-- parameter expr. If the condition is false (i.e. expr is equal to 0),
-- the macro sends diagnostics to stderr and calls the abort function.
--
-- The insist macro is a replacement of the standard macro assert. */

void _insist(char *expr, char *file, int line)
{     fprintf(stderr, "\nAssertion failed: %s, file %s, line %d\n",
         expr, file, line);
      abort();
      /* no return */
}

/* eof */
