/* glpavl/find_by_key.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glpavl.h"
#include "glpset.h"

/*----------------------------------------------------------------------
-- find_by_key - search for the first node with given key in AVL-tree.
--
-- *Synopsis*
--
-- #include "glpavl.h"
-- AVLNODE *find_by_key(AVLTREE *tree, void *key);
--
-- *Description*
--
-- The find_by_key routine searches for the first node in the AVL-tree
-- that has the given key. (To perform this operation the keys comparing
-- routine should be defined.)
--
-- In order to find all other nodes that have the same key the routine
-- next_by_key can be used.
--
-- *Returns*
--
-- The find_by_key routine returns a pointer to the node that has the
-- given key, or NULL if such node does not exist. */

AVLNODE *find_by_key(AVLTREE *tree, void *key)
{     AVLNODE *p, *q;
      int c;
      if (tree->comp == NULL)
         fault("find_by_key: keys comparing routine not defined");
      p = tree->root;
      while (p != NULL)
      {  c = tree->comp(key, p->key);
         if (c == 0) break;
         p = (c < 0 ? p->left : p->right);
      }
      if (p != NULL) for (;;)
      {  q = prev_node(tree, p);
         if (q == NULL) break;
         if (tree->comp(q->key, p->key) != 0) break;
         p = q;
      }
      return p;
}

/* eof */
