/* glprsm/rsm_check_basis.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <assert.h>
#include "glprsm.h"

/*----------------------------------------------------------------------
-- rsm_check_basis - check basis segment for correctness.
--
-- *Synopsis*
--
-- #include "glprsm.h"
-- void rsm_check_basis(RSM *rsm);
--
-- *Description*
--
-- The rsm_check_basis checks basis segment data structures (see RSM
-- structure) for correctness. */

void rsm_check_basis(RSM *rsm)
{     int m = rsm->m, n = rsm->n, i, j, k;
      for (k = 1; k <= m+n; k++)
      {  if (rsm->posx[k] > 0)
         {  i = +rsm->posx[k]; /* xB[i] = x[k] */
            assert(1 <= i && i <= m);
            assert(rsm->indb[i] == k);
         }
         else if (rsm->posx[k] < 0)
         {  j = -rsm->posx[k]; /* xN[j] = x[k] */
            assert(1 <= j && j <= n);
            assert(rsm->indn[j] == k);
            switch (rsm->type[k])
            {  case LP_FR:
                  assert(rsm->tagn[j] == LP_NF);
                  break;
               case LP_LO:
                  assert(rsm->tagn[j] == LP_NL);
                  break;
               case LP_UP:
                  assert(rsm->tagn[j] == LP_NU);
                  break;
               case LP_DB:
                  assert(rsm->tagn[j] == LP_NL || rsm->tagn[j] == LP_NU)
                     ;
                  break;
               case LP_FX:
                  assert(rsm->tagn[j] == LP_NS);
                  break;
               default:
                  assert(rsm->tagn[j] != rsm->tagn[j]);
            }
         }
         else
            assert(rsm->posx[k] != rsm->posx[k]);
      }
      return;
}

/* eof */
