/* glpstr/create_str_pool.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glpstr.h"

/*----------------------------------------------------------------------
-- create_str_pool - create pool for segmented character strings.
--
-- *Synopsis*
--
-- #include "glpstr.h"
-- POOL *create_str_pool(void);
--
-- *Description*
--
-- The create_str_pool routine creates a memory pool which may be used
-- in subsequent operations on segmented character strings. Should note
-- that different strings can share the same pool.
--
-- *Returns*
--
-- The create_str_pool routine returns a pointer to the created memory
-- pool. */

POOL *create_str_pool(void)
{     POOL *pool;
      int size1 = sizeof(STR);
      int size2 = sizeof(SQE);
      pool = create_pool(size1 >= size2 ? size1 : size2);
      return pool;
}

/* eof */
