/* glpset/free_atom.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glpset.h"

/*----------------------------------------------------------------------
-- free_atom - free an atom.
--
-- *Synopsis*
--
-- #include "glpset.h"
-- void free_atom(POOL *pool, void *ptr);
--
-- *Description*
--
-- The free_atom routine frees an atom pointed to by ptr, returning
-- this atom to the free atom list of the specified pool. It is assumed
-- that the atom was allocated from the same pool by get_atom routine,
-- otherwise the behavior is undefined. */

void free_atom(POOL *pool, void *ptr)
{     if (pool->size == 0)
         fault("free_atom: pool cannot be used to free an atom");
      if (pool->count == 0)
         fault("free_atom: pool allocation error");
      /* return the atom to the list of free atoms */
      *(void **)ptr = pool->avail;
      pool->avail = ptr;
      pool->count--;
      return;
}

/* eof */
