/* glpmat/create_mat.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glpmat.h"
#include "glpset.h"

/*----------------------------------------------------------------------
-- create_mat - create sparse matrix.
--
-- *Synopsis*
--
-- #include "glpmat.h"
-- MAT *create_mat(int m, int n);
--
-- *Description*
--
-- The create_mat routine creates a real sparse matrix with m rows and
-- n columns. The created matrix initially is null matrix.
--
-- *Returns*
--
-- The create_mat returns a pointer to the created matrix. */

MAT *create_mat(int m, int n)
{     MAT *A;
      if (!(m > 0 && n > 0))
         fault("create_mat: invalid dimension");
      A = umalloc(sizeof(MAT));
      A->m = m;
      A->n = n;
      A->pool = create_pool(sizeof(ELEM));
      A->row = ucalloc(1+m, sizeof(ELEM *));
      A->col = ucalloc(1+n, sizeof(ELEM *));
      return A;
}

/* eof */
