/* glpeta/create_eta.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glpeta.h"
#include "glpset.h"

/*----------------------------------------------------------------------
-- create_eta - create eta-file.
--
-- *Synopsis*
--
-- #include "glpeta.h"
-- HFILE *create_eta(int n);
--
-- *Description*
--
-- The create_eta routine creates eta-file represented a square matrix
-- of order n. Initially the created eta-file has no terms, therefore
-- formally it corresponds to unity matrix.
--
-- *Returns*
--
-- The create_eta routine returns a pointer to the created eta-file. */

HFILE *create_eta(int n)
{     HFILE *eta;
      if (n < 1)
         fault("create_eta: invalid order");
      eta = umalloc(sizeof(HFILE));
      eta->n = n;
      eta->pool = create_pool(sizeof(HTERM));
      eta->head = eta->tail = NULL;
      return eta;
}

/* eof */
