/* glpduff/include_obj.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glpduff.h"
#include "glpset.h"

/*----------------------------------------------------------------------
-- include_obj - include object to Duff's scheme.
--
-- *Synopsis*
--
-- #include "glpduff.h"
-- void include_obj(DUFF *duff, int k, int len);
--
-- *Description*
--
-- The include_obj routine includes an object to the Duff's scheme. The
-- parameter k is the number of the included object, the parameter len
-- is the length of the included object. The object should be not in the
-- scheme before inclusion. */

void include_obj(DUFF *duff, int k, int len)
{     if (!(1 <= k && k <= duff->n))
         fault("include_obj: invalid object number");
      if (!(0 <= len && len <= duff->maxlen))
         fault("include_obj: invalid object length");
      if (duff->len[k] >= 0)
         fault("include_obj: object is already in the scheme");
      duff->len[k] = len;
      duff->prev[k] = 0;
      duff->next[k] = duff->head[len];
      if (duff->head[len] == 0)
         /* nop */;
      else
         duff->prev[duff->head[len]] = k;
      duff->head[len] = k;
      return;
}

/* eof */
