/* glpapi/glp_set_ipar.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <string.h>
#include "glpapi.h"

/*----------------------------------------------------------------------
-- glp_set_ipar - set value of integer control parameter.
--
-- *Synopsis*
--
-- #include "glpk.h"
-- int glp_set_ipar(char *name, int val);
--
-- *Description*
--
-- The glp_set_ipar routine assigns the given value val to the integer
-- control parameter with the given name.
--
-- See the documentation for descriptions of all control parameters.
--
-- *Returns*
--
-- 0 - no errors;
-- 1 - the given name is invalid;
-- 2 - the given value is invalid. */

int glp_set_ipar(char *name, int val)
{     if (strcmp(name, "mps_one_entry") == 0)
      {  /* write MPS file not using fields 5 and 6 */
         if (!(val == GLP_NO || val == GLP_YES)) return 2;
         glp->mps_one_entry = val;
      }
      else if (strcmp(name, "mps_pedantic") == 0)
      {  /* write MPS file using pedantic style */
         if (!(val == GLP_NO || val == GLP_YES)) return 2;
         glp->mps_pedantic = val;
      }
      else if (strcmp(name, "mps_skip_empty") == 0)
      {  /* don't write empty columns to MPS file */
         if (!(val == GLP_NO || val == GLP_YES)) return 2;
         glp->mps_skip_empty = val;
      }
      else if (strcmp(name, "mps_use_names") == 0)
      {  /* use original names as templates to generate MPS names */
         if (!(val == GLP_NO || val == GLP_YES)) return 2;
         glp->mps_use_names = val;
      }
      else if (strcmp(name, "obj_dir") == 0)
      {  /* optimization direction flag */
         if (!(val == GLP_INI || val == GLP_ANY ||
               val == GLP_MIN || val == GLP_MAX)) return 2;
         glp->obj_dir = val;
      }
      else if (strcmp(name, "round") == 0)
      {  /* round the computed values of basis variable */
         if (!(val == GLP_NO || val == GLP_YES)) return 2;
         glp->round = val;
      }
      else if (strcmp(name, "scale") == 0)
      {  /* scale the problem before solving */
         if (!(val == GLP_NO || val == GLP_YES)) return 2;
         glp->scale = val;
      }
      else if (strcmp(name, "spx_form") == 0)
      {  /* the form of the basis matrix used by the solver */
         if (!(val == GLP_EFI ||
               val == GLP_RFI_BG || val == GLP_RFI_FT)) return 2;
         glp->spx_form = val;
      }
      else if (strcmp(name, "spx_relax") == 0)
      {  /* use the ratio test proposed by P.Harris */
         if (!(val == GLP_NO || val == GLP_YES)) return 2;
         glp->spx_relax = val;
      }
      else if (strcmp(name, "spx_steep") == 0)
      {  /* use the steepest edge technique */
         if (!(val == GLP_NO || val == GLP_YES)) return 2;
         glp->spx_steep = val;
      }
      else if (strcmp(name, "spx_use_dual") == 0)
      {  /* use dual simplex to search for feasible solution */
         if (!(val == GLP_NO || val == GLP_YES)) return 2;
         glp->spx_use_dual = val;
      }
      else if (strcmp(name, "status") == 0)
      {  /* status of the computed solution (set bythe solver) */
         if (!(val == GLP_UNDEF  || val == GLP_OPT    ||
               val == GLP_FEAS   || val == GLP_INFEAS ||
               val == GLP_NOFEAS || val == GLP_UNBND)) return 2;
         glp->status = val;
      }
      else if (strcmp(name, "sum_aij") == 0)
      {  /* sum multiplets of the constraint matrix */
         if (!(val == GLP_NO || val == GLP_YES)) return 2;
         glp->sum_aij = val;
      }
      else
      {  /* invalid parameter name */
         return 1;
      }
      return 0;
}

/* eof */
