/* Declare the class Object for Objective C programs.
   Copyright (C) 1992 Free Software Foundation, Inc.

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* As a special exception, if you link this library with files
   compiled with GCC to produce an executable, this does not cause
   the resulting executable to be covered by the GNU General Public License.
   This exception does not however invalidate any other reasons why
   the executable file might be covered by the GNU General Public License.  */

#ifndef __object_INCLUDE_GNU
#define __object_INCLUDE_GNU

#include "objc.h"
#include "stdio.h"


/*
 * All classes are derived from Object.  As such this is the 
 *  overhead tacked onto those objects.  
 */
@interface Object {
  Class_t isa;                                  /* A pointer to the instance's 
                                                  class structure. 
                                                  
                                                  This structure is the one
                                                  generated by the compiler
                                                  and located in the TEXT 
                                                  segment.  The run-time uses
                                                  its address as a key to 
                                                  run-time information. */
}

/* Creating, copying, and freeing instances */

+ new;
+ free;
- free;
- copy;
- shallowCopy;
- deepCopy;

/* Identifying classes */

+ ( Class_t )class;
+ ( Class_t )superClass;
- ( Class_t )class;
- ( Class_t )superClass;
- ( const char* )name;

/* Identifying and comparing instances */

- self;
- ( unsigned int )hash;
- ( BOOL )isEqual:anObject;

/* Testing inheritance relationships */

- ( BOOL )isKindOf:( Class_t )aClassObject;
- ( BOOL )isMemberOf:( Class_t )aClassObject;
- ( BOOL )isKindOfGivenName:( const char* )aClassName;
- ( BOOL )isMemberOfGivenName:( const char* )aClassName;

/* Testing class functionality */

+ ( BOOL )instancesRespondTo:( SEL )aSel;
- ( BOOL )respondsTo:( SEL )aSel;

/* Sending messages determined at run time */

- perform:( SEL )aSel;
- perform:( SEL )aSel with:aObject;

/* Posing */

+ poseAs:( Class_t )aClassObject;

/* Enforcing intentions */
 
- subclassResponsibility:( SEL )aSel;
- notImplemented:( SEL )aSel;

/* Error handling */

- doesNotRecognize:(SEL)aSelector;
- error:( const char* )aString, ...;
+ error:( const char* )aString, ...;

/* Archiving */

- storeOn:( int )aFd;
+ readFrom:( int )aFd;
- readFrom:( int )aFd;
+ ( int )version;
+ setVersion:( int )aVersion;

@end


#endif

