/* read_rasterfile.c -- How to read a sun rasterfile. */

/* Copyright (C) 1988, 1990, 1992 Free Software Foundation, Inc.

   This file is part of GNU Finger.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


/* This code requires functions in bitmaps.c. */

#include <config.h>
#include <sys/types.h>
#include <sys/file.h>

#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif

#include <bitmap.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#if defined (HAVE_SUN_WINDOWS)
#include <rasterfile.h>
#else
struct rasterfile {
  int ras_magic, ras_width, ras_height, ras_depth, ras_length;
  int ras_type, ras_maptype;
  int ras_maplength;
};

#ifndef L_SET
#define L_SET SEEK_SET
#define L_INCR SEEK_CUR
#endif /* !L_SET */


/* Today.  I don't know what it is tommorrow. */
#define RAS_MAGIC 0X59A66A95

#define RT_OLD 0
#define RT_STANDARD 1
#define RT_BYTE_ENCODED 2
#endif  /* HAVE_SUN_WINDOWS */

BITMAP *
read_rasterfile (user)
     char *user;
{
  int size, file, len;
  BITMAP *face = (BITMAP *)NULL;
  char *filename = mugshot_filename (user);
  byte *pix1, *pix2;
  struct rasterfile header;

  file = open (filename, O_RDONLY);

  free (filename);
  if (file < 0)
    return (BITMAP *)NULL;

  if ((read (file, &header, sizeof (header)) != sizeof (header)) ||
      header.ras_magic != RAS_MAGIC)
    {
      close (file);
      return (BITMAP *)NULL;
    }

#ifdef L_INCR
  /* BSD */
  if (header.ras_maplength)
    lseek (file, header.ras_maplength, L_INCR);
#else
  /* USG */
  if (header.ras_maplength)
    lseek (file, header.ras_maplength, SEEK_CUR);
#endif

  face = (BITMAP *)xmalloc (sizeof (BITMAP));
  face->width = header.ras_width;
  face->height= header.ras_height;
  face->rowlen = ROWBYTES (face->width);

  /* If the data in this file needs to be dithered, maybe we should do that.
     Then again, maybe we shouldn't. */
  if (header.ras_depth > 1)
    {
#ifdef DITHER
      if (header.ras_depth == 8)
	{
	  byte *dither (), *image = (byte *)xmalloc (header.ras_length);

	  read (file, image, header.ras_length);

	  face->bits = dither (image, header.ras_width,
			       header.ras_height,
			       ((header.ras_width + 15) / 16) * 2);
	  free (image);
	}
      else
	{
	  close (file);
	  free (face);
	  return (BITMAP *)NULL;
	}
#else
      close (file);
      free (face);
      return (BITMAP *)NULL;
#endif  /* DITHER */
    }
  else
    {
      size = face->rowlen * face->height;
      face->bits = (byte *)xmalloc (size);
      read (file, face->bits, size);
    }
  close (file);
  (void) reverse_image_bit_order (face);
  (void) pad_face (face, 1);
  return (face);
}

