;;; epop3hash.el --- utility macro for epop3mail.el and biff-mode.el
;;
;; Author:        Franklin Lee <flee@lehman.com>
;; Created:       11/1997
;; Keywords:      mail pop3
;; Version:       0.7.8
;;
;; Copyright (C) 1997, 1998 Franklin Lee
;;
;; This program is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by the
;; Free Software Foundation; either version 2, or (at your option) any
;; later version.
;;
;; epop3mail.el is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License along
;; with GNU Emacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
;;

;;; Commentary:

;; a macro for cleanth and readability.

;;
;;; History:
;;  --------
;;
;; 12/21/1997 version 0.6: added dohash macro to epop3mail.el to make
;; epop3-get-unread-message-numbers more readable and cleaner ("Cleanth is
;; next to Godth!").
;;
;; 01/11/1998 version 0.7.8: separated dohash macro out from epop3mail.el
;; to its own file.
;;
;; 02/02/1999 changed the eval-and-compile per jari aalto's suggestion
;;
;; TO-DO:
;; - perhaps using obarrays instead of cl-hash tables for speedth?

;;; Code:

;; extending the 'cl' package a bit...
;; dohash is to hash-tables as dolist is to lists...
;;

(eval-and-compile
  (require 'cl)
  (or (fboundp 'cl-gethash)
      (load "cl-extra")))		;has no provide

(or (featurep 'cl)
    (require 'cl))

(or (fboundp 'epop3-dohash)
	;; much thanks to rickc@lehman.com ("the hacker formerly known as
	;; rfb@lehman.com") for his help with this macro.
	(defmacro epop3-dohash (spec &rest body)
	  "(dohash (KEY VALUE HASH-TABLE [RESULT]) BODY): loop over a hashtable.
'dohash' is to hash tables as 'dolist' is to lists.  This assumes 'maphash'
in package 'cl-extra'."
	  (let ((mapper (gensym "MAPPER-"))
			(key (car spec))
			(value (nth 1 spec))
			(tab (nth 2 spec))
			(result (nth 3 spec)))
		`(block nil
		   (flet ((,mapper (,key ,value) ,@body))
			 (maphash (function ,mapper) ,tab)
			 ,result)))))

;;
;; make nice on the indentations
;;
(put 'epop3-dohash 'common-lisp-indent-function '((&whole 4 2 1) &body))
(put 'epop3-dohash 'lisp-indent-function 1)

(defalias 'puthash 'cl-puthash)
(defalias 'gethash 'cl-gethash)

(provide 'epop3hash)

;;; epop3hash.el ends here
