/* Copyright (C) 1997 Aladdin Enterprises.  All rights reserved.
  
  This file is part of GNU Ghostscript.
  
  GNU Ghostscript is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility to
  anyone for the consequences of using it or for whether it serves any
  particular purpose or works at all, unless he says so in writing.  Refer to
  the GNU General Public License for full details.
  
  Everyone is granted permission to copy, modify and redistribute GNU
  Ghostscript, but only under the conditions described in the GNU General
  Public License.  A copy of this license is supposed to have been given to
  you along with GNU Ghostscript so you can know your rights and
  responsibilities.  It should be in a file named COPYING.  Among other
  things, the copyright notice and this notice must be preserved on all
  copies.
  
  Aladdin Enterprises is not affiliated with the Free Software Foundation or
  the GNU Project.  GNU Ghostscript, as distributed by Aladdin Enterprises,
  does not depend on any other GNU software.
*/

/* $Id: gsdpsx.h,v 1.6 2000/04/04 17:02:32 cigas Exp $ */
/* Client interface to DPS X11 functions */

#ifndef gsdpsx_INCLUDED
#define gsdpsx_INCLUDED

#include "gsdevice.h"

/* I think even these defines are unnecessary since not including any
   X headers ... JC */

#ifndef CARD16
#define CARD16 unsigned short
#define Window unsigned int
#define WE_DEFINED
#endif


/* original versions
int gsdpsx_get_offset(P2(gx_device_X * dev, int x0_or_y1));
void gsdpsx_set_offset(P3(gx_device_X * dev, int offset, int x0_or_y1));
*/

/* these two functions are now implemented in dgsagent.c */
int gsdpsx_get_offset(P2(gx_device * dev, int x0_or_y1));
void gsdpsx_set_offset(P3(gx_device * dev, int offset, int x0_or_y1));

#ifdef WE_DEFINED
#undef CARD16
#undef Window
#undef WE_DEFINED
#endif


#endif /* gsdpsx_INCLUDED */
