/* Copyright (C) 1997 Aladdin Enterprises.  All rights reserved.
  
  This file is part of GNU Ghostscript.
  
  GNU Ghostscript is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility to
  anyone for the consequences of using it or for whether it serves any
  particular purpose or works at all, unless he says so in writing.  Refer to
  the GNU General Public License for full details.
  
  Everyone is granted permission to copy, modify and redistribute GNU
  Ghostscript, but only under the conditions described in the GNU General
  Public License.  A copy of this license is supposed to have been given to
  you along with GNU Ghostscript so you can know your rights and
  responsibilities.  It should be in a file named COPYING.  Among other
  things, the copyright notice and this notice must be preserved on all
  copies.
  
  Aladdin Enterprises is not affiliated with the Free Software Foundation or
  the GNU Project.  GNU Ghostscript, as distributed by Aladdin Enterprises,
  does not depend on any other GNU software.

  However Display Ghostscript System depends on GLib. */

/* $Id: dgsmisc.h,v 1.1 2000/02/21 03:46:19 cigas Exp $ */

#ifndef dgsmisc_INCLUDED
#define dgsmisc_INCLUDED

#include "dgs.h"

/* --- context init parameter  --- */
GSet *g_set_add(GSet * set, gpointer data);
gpointer g_set_member(GSet * set, gpointer data);
GSet *g_set_remove(GSet * set, gpointer data);
void g_set_foreach(GSet * set, GFunc func, gpointer user_data);
guint g_set_count(GSet * set);

/* utility functions */
const char *util_x_ps_request_enum2str(int key);
const char *util_x_cap_request_enum2str(int key);
const char *util_signal_int2str(int sig);
const char *util_status_enum2str(int key);
const char *util_conn_type_enum2str(enum conn_type type);
int util_byteorder_check(gsdpsx_conn_info * conn);

void debug_print_pid(int sec);

#endif /* dgsmisc_INCLUDED */
