/* Copyright (C) 1997 Aladdin Enterprises.  All rights reserved.
  
  This file is part of GNU Ghostscript.
  
  GNU Ghostscript is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility to
  anyone for the consequences of using it or for whether it serves any
  particular purpose or works at all, unless he says so in writing.  Refer to
  the GNU General Public License for full details.
  
  Everyone is granted permission to copy, modify and redistribute GNU
  Ghostscript, but only under the conditions described in the GNU General
  Public License.  A copy of this license is supposed to have been given to
  you along with GNU Ghostscript so you can know your rights and
  responsibilities.  It should be in a file named COPYING.  Among other
  things, the copyright notice and this notice must be preserved on all
  copies.
  
  Aladdin Enterprises is not affiliated with the Free Software Foundation or
  the GNU Project.  GNU Ghostscript, as distributed by Aladdin Enterprises,
  does not depend on any other GNU software.

  However Display Ghostscript System depends on GLib. */

/* $Id: dgs.h,v 1.2 2000/02/28 19:31:31 cigas Exp $ */

#ifndef dgs_INCLUDED
#define dgs_INCLUDED

#include <glib.h>		/* For Hash tables */
typedef GSList GSet;

#include "DPS/dpsNXargs.h"
enum conn_type { UNIXCONN = XDPSNX_TRANS_UNIX, TCPCONN = XDPSNX_TRANS_TCP };

typedef struct gsdpsx_conn_buf_s
{
    unsigned char *buf;
    unsigned char *curpos;
    unsigned int len;		/* if we need to leave messages here, the remaining length */
    unsigned char *inputstart;	/* these are for when we get an input message in here */
    unsigned char *inputend;
    int isfrag;			/* first item in the buffer is a partial fragment */
}
gsdpsx_conn_buf;

#include "DPS/XDPSproto.h"
struct ctx_init_parameter 
{
  CONTEXTXID cxid;
  Drawable drawable;
  int offset_x;
  int offset_y;
};

typedef struct gsdpsx_conn_info_s
{
    Window agent_win;
    Window clientWindow;
    unsigned int serial;
    CARD16 displayNum;		/* don't know, but we get it... */
    CARD16 screen;
    Atom resume_atom;
    /*gx_device_X *primary_device; -- now local to dgsagent.c */

    int sock;
    unsigned char byteorder;
    enum conn_type conn_type;
    gsdpsx_conn_buf *buf;

    int context_state_index_primary;
    int context_state_index_last;

    GHashTable *cpsid_to_cxid_table;
    GHashTable *cxid_to_cpsid_table;
    GSet *pause_cxids_set;
    GSet *kill_cpsids_set;
    GHashTable *cpsid_to_mask_table;
    GHashTable *cpsid_to_nextMask_table;
    struct ctx_init_parameter ctx_init_parameter;
} gsdpsx_conn_info;

extern gsdpsx_conn_info conn_info;

enum scheduling_action
{
    SCHED_ACT_NOTHING,		/* Forward data from socket to the gs interpreter */
    SCHED_ACT_FORK,		/* Fork request */
    SCHED_ACT_YIELD,		/* Context switching request  */
    SCHED_ACT_DETACH		/* Context killing request */
};


/* Watchout when upgrading to new version of gs - these will change!! */

/* declaration secret functions in zcontext.c */
int gsdpsx_get_current_context_index(void);
void gsdpsx_request_context_index(int index);
void gsdpsx_clear_newest_context(void);
int gsdpsx_get_newest_context_index(void);
int gsdpsx_count_ready_context(void);
void gsdpsx_set_primary_context_index(int index);

extern int DGS_DEBUG;
extern int DGS_PORT;
/* Connection type was NOT settable in dgs 0.5.9.1 */
extern enum conn_type DGS_TRANSPORT;

extern Display *shared_dpy;	/*! NOT GOOD NAME */
extern unsigned char shared_byteorder;
extern int billboard_atom_needs_cleanup;
extern Window server_win_tcp;
extern Window server_win_unix;
extern GSet *server_agent_pids;

#endif /* dgs_INCLUDED */
