#    Copyright (C) 1989, 1995, 1996 Aladdin Enterprises.  All rights reserved.
# 
# This file is part of Aladdin Ghostscript.
# 
# Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
# or distributor accepts any responsibility for the consequences of using it,
# or for whether it serves any particular purpose or works at all, unless he
# or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
# License (the "License") for full details.
# 
# Every copy of Aladdin Ghostscript must include a copy of the License,
# normally in a plain ASCII text file named PUBLIC.  The License grants you
# the right to copy, modify and redistribute Aladdin Ghostscript, but only
# under certain conditions described in the License.  Among other things, the
# License requires that the copyright notice and this notice be preserved on
# all copies.

# makefile for (MS-Windows 3.1 / Win32s / Windows NT) +
#   Borland C++ 4.0 platform.

# ------------------------------- Options ------------------------------- #

###### This section is the only part of the file you should need to edit.

# ------ Generic options ------ #

# Define the directory that will hold documentation at runtime.

GS_DOCDIR=c:/gs

# Define the default directory/ies for the runtime
# initialization and font files.  Separate multiple directories with \;.
# Use / to indicate directories, not a single \.

GS_LIB_DEFAULT=.;c:/gs\;c:/gs/fonts

# Define the name of the interpreter initialization file.
# (There is no reason to change this.)

GS_INIT=gs_init.ps

# Choose generic configuration options.

# Setting DEBUG=1 includes debugging features (-Z switch) in the code.
# Code runs substantially slower even if no debugging switches are set,
# and also takes about another 25K of memory.

DEBUG=0

# Setting TDEBUG=1 includes symbol table information for the Borland debugger.
# No execution time or space penalty, just larger .OBJ and .EXE files
# and slower linking.

TDEBUG=0

# Setting NOPRIVATE=1 makes private (static) procedures and variables public,
# so they are visible to the debugger and profiler.
# No execution time or space penalty, just larger .OBJ and .EXE files.

NOPRIVATE=0

# Define the name of the executable file.

GS=gswin32
GSCONSOLE=gswin32c
GSDLL=gsdll32

# To build two small executables and a large DLL use MAKEDLL=1
# To build two large executables use MAKEDLL=0
MAKEDLL=1

# Define the directory where the IJG JPEG library sources are stored,
# and the major version of the library that is stored there.
# You may need to change this if the IJG library version changes.
# See jpeg.mak for more information.

JSRCDIR=jpeg-6a
JVERSION=6

# Define the directory where the PNG library sources are stored,
# and the version of the library that is stored there.
# You may need to change this if the libpng version changes.
# See libpng.mak for more information.

PSRCDIR=libpng
PVERSION=89

# Define the directory where the zlib sources are stored.
# See zlib.mak for more information.

ZSRCDIR=zlib

# Define the configuration ID.  Read gs.mak carefully before changing this.

CONFIG=

# Define any other compilation flags.  Including -DA4 makes A4 paper size
# the default for most, but not, printer drivers.

CFLAGS=

# ------ Platform-specific options ------ #

# If you don't have an assembler, set USE_ASM=0.  Otherwise, set USE_ASM=1,
# and set ASM to the name of the assembler you are using.  This can be
# a full path name if you want.  Normally it will be masm or tasm.

USE_ASM=0
ASM=tasm

# Define the drive, directory, and compiler name for the Turbo C files.
# COMP is the compiler name (bcc32 for Borland C++).
# COMPAUX is the compiler name for DOS utilities (bcc for Borland C++).
# RCOMP is the resource compiler name (brcc32 for Borland C++)
# COMPDIR contains the compiler and linker (normally \bc45\bin).
# INCDIR contains the include files (normally \bc45\include).
# LIBDIR contains the library files (normally \bc45\lib).
# Note that these prefixes are always followed by a \,
#   so if you want to use the current directory, use an explicit '.'.

COMP=bcc32
COMPAUX=bcc
RCOMP=brcc32
COMPBASE=c:\bc45
COMPDIR=$(COMPBASE)\bin
INCDIR=$(COMPBASE)\include
LIBDIR=$(COMPBASE)\lib

# Define the Windows directory.

WINDIR=c:\windows

# Windows 32s requires a 386 CPU or higher.

CPU_TYPE=386

# Don't rely on FPU for Windows: Options are -1 (optimize for no FPU) or
# 0 (optimize for FPU present, but do not require a FPU).

FPU_TYPE=0

# ---------------------------- End of options ---------------------------- #

# Swapping `make' out of memory makes linking much faster.

.swap

# Define the platform name.

PLATFORM=bcwin32_

# Define the name of the makefile -- used in dependencies.

MAKEFILE=bcwin32.mak

# Define the ANSI-to-K&R dependency.  Turbo C accepts ANSI syntax,
# but we need to preconstruct ccf32.tr to get around the limit on
# the maximum length of a command line.

AK=ccf32.tr

# Define the compilation flags for an 80286.
# This is only needed because it is used in tccommon.mak.

F286=

# Define compiler switches appropriate to this version of Borland C++.
# We know we are running C++ 4.0 or later, because earlier versions
# don't support Windows 32s.

# -Obe is causing bcc32.exe to crash on gsimage2.c
#CO=-Obe -Z	
CO=-Z
CAOPT=-a1
WINCOMP=1

# Make sure we get the right default target for make.
win32default: dosdefault gs16spl.exe

!include "tccommon.mak"

# Define the compilation flags.

!if $(NOPRIVATE)
CP=-DNOPRIVATE
!else
CP=
!endif

!if $(DEBUG) | $(TDEBUG)
CS=-N
!else
CS=
!endif

!if $(DEBUG)
CD=-DDEBUG
!else
CD=
!endif

!if $(TDEBUG)
CT=-v
LCT=-v -m -s
!else
CT=
LCT=-m
!endif

GENOPT=$(CP) $(CS) $(CD) $(CT)

CCFLAGS0=$(GENOPT) $(PLATOPT) $(FPFLAGS) $(CFLAGS) $(XCFLAGS)
CCFLAGS=$(CCFLAGS0)
CC=$(COMPDIR)\$(COMP) @ccf32.tr
!if $(MAKEDLL)
WX=-WDE
!else
WX=-WE
!endif
CCC=$(CC) $(WX) $(CO) -c
CCD=$(CC) $(WX) -O -c
CCCF=$(CCC)
CCINT=$(CC) $(WX) -c
CCLEAF=$(CCC)

.c.obj:
	$(CCC) { $<}

# ------ Devices and features ------ #

# Choose the language feature(s) to include.  See gs.mak for details.
# With a 32-bit address space, we don't have to worry about overflowing
# the 64K primary data segment, so we include plenty of drivers.

FEATURE_DEVS=level2.dev pdf.dev ttfont.dev

# Choose whether to compile the .ps initialization files into the executable.
# See gs.mak for details.

COMPILE_INITS=0

# Choose the device(s) to include.  See devs.mak for details.

DEVICE_DEVS=mswindll.dev mswinprn.dev mswinpr2.dev
DEVICE_DEVS2=epson.dev eps9high.dev eps9mid.dev epsonc.dev ibmpro.dev
DEVICE_DEVS3=deskjet.dev djet500.dev laserjet.dev ljetplus.dev ljet2p.dev ljet3.dev ljet4.dev
DEVICE_DEVS4=cdeskjet.dev cdjcolor.dev cdjmono.dev cdj550.dev pj.dev pjxl.dev pjxl300.dev
DEVICE_DEVS5=djet500c.dev declj250.dev lj250.dev jetp3852.dev r4081.dev lbp8.dev
DEVICE_DEVS6=st800.dev stcolor.dev bj10e.dev bj200.dev m8510.dev necp6.dev bjc600.dev bjc800.dev
DEVICE_DEVS7=t4693d2.dev t4693d4.dev t4693d8.dev tek4696.dev
DEVICE_DEVS8=pcxmono.dev pcxgray.dev pcx16.dev pcx256.dev pcx24b.dev
DEVICE_DEVS10=tiffcrle.dev tiffg3.dev tiffg32d.dev tiffg4.dev tifflzw.dev tiffpack.dev
DEVICE_DEVS11=bmpmono.dev bmp16.dev bmp256.dev bmp16m.dev tiff12nc.dev tiff24nc.dev
DEVICE_DEVS12=psmono.dev bit.dev bitrgb.dev bitcmyk.dev
DEVICE_DEVS13=pngmono.dev pnggray.dev png16.dev png256.dev png16m.dev
DEVICE_DEVS15=pdfwrite.dev

!include "tctail.mak"
!include "int.mak"

# Build the compiler response file depending on the selected options.

ccf32.tr: $(MAKEFILE) makefile
	echo -a1 -d -r -G -N -X -I$(INCDIR) $(CCFLAGS0) -DCHECK_INTERRUPTS>ccf32.tr

# -------------------------------- Library -------------------------------- #

# The Turbo/Borland C(++), Microsoft Windows platform

# Using a file device resource to get the console streams re-initialized
# is bad architecture (an upward reference to ziodev),
# but it will have to do for the moment.
bcwin32__=gp_mswin.$(OBJ) gp_win32.$(OBJ) gp_nofb.$(OBJ) gp_ntfs.$(OBJ)
bcwin32_.dev: $(bcwin32__)
	$(SETMOD) bcwin32_ $(bcwin32__)
	$(ADDMOD) bcwin32_ -iodev wstdio

gp_mswin.$(OBJ): gp_mswin.c $(AK) gp_mswin.h \
 $(ctype__h) $(dos__h) $(malloc__h) $(memory__h) $(stdio__h) $(string__h) $(windows__h) \
 $(gx_h) $(gp_h) $(gpcheck_h) $(gserrors_h) $(gsexit_h) $(gxiodev_h) $(stream_h)

# ----------------------------- Main program ------------------------------ #

BEGINFILES=gs*.ico ccf32.tr $(GS).res $(GSDLL).res $(GSDLL).dll $(GSCONSOLE).exe gs16spl.res gs16spl.exe
CCBEGIN=$(CCC) *.c

# Get around the fact that the DOS shell has a rather small limit on
# the length of a command line.  (sigh)

LIBCTR=libc32.tr

$(LIBCTR): $(MAKEFILE) makefile $(ECHOGS_XE)
	echogs -w $(LIBCTR) $(LIBDIR)\import32+
	echogs -a $(LIBCTR) $(LIBDIR)\cw32

# Interpreter main program

!include "dwcommon.mak"

GS_ALL=$(INT_ALL) $(INTASM)\
  $(LIB_ALL) $(LIBCTR) $(ld_tr) lib.tr $(GSDLL).res $(GSDLL).def $(ICONS)

$(GSDLL).res: $(GSDLL).rc gp_mswin.h $(ICONS)
	$(COMPDIR)\brc32 -i$(INCDIR) -r $(GSDLL)

!if $(MAKEDLL)
$(GS_XE): $(GSDLL).dll $(GSCONSOLE).exe

$(GSDLL).dll: $(GS_ALL) $(DEVS_ALL) gsdll.$(OBJ) $(GSDLL).res
	tlink32 $(LCT) /Tpd $(LIBDIR)\c0d32 gsdll @$(ld_tr) $(INTASM) ,$(GSDLL).dll,$(GSDLL),@lib.tr @$(LIBCTR),$(GSDLL).def,$(GSDLL).res
!endif

# The small EXE loader

.cpp.obj:
	$(COMPDIR)\$(COMP) -c -I$(INCDIR) -WE $(CT) {$< }

!if $(MAKEDLL)
$(GS_XE): $(GSDLL).dll $(DWOBJ) $(GS).res dwmain32.def
	$(COMPDIR)\tlink32 /Tpe $(LCT) @&&!
$(LIBDIR)\c0w32 +
$(DWOBJ) +
,$(GS_XE),$(GS), +
$(LIBDIR)\import32 +
$(LIBDIR)\cw32, +
dwmain32.def, +
$(GS).res
!
!else
dwnodll.obj: dwnodll.cpp dwdll.h gsdll.h

DWOBJNO = dwnodll.obj dwimg.obj dwmain.obj dwtext.obj

$(GS_XE):   $(GSCONSOLE).exe $(GS_ALL) $(DEVS_ALL) gsdll.$(OBJ) $(DWOBJNO) $(GS).res dwmain32.def
	copy $(ld_tr) gswin32.tr
	echo $(DWOBJNO) + >> gswin32.tr
	tlink32 $(LCT) /Tpe $(LIBDIR)\c0w32 gsdll @gswin32.tr $(INTASM) ,$(GS_XE),$(GS),@lib.tr @$(LIBCTR),dwmain32.def,$(GS).res
	-del gswin32.tr
!endif

# Console mode loader

OBJC=dwmainc.obj dwdllc.obj gscdefs.obj

dwmainc.obj: dwmainc.cpp dwmain.h dwdll.h gscdefs.h gsdll.h
	$(COMPDIR)\$(COMP) -c -I$(INCDIR) -WC dwmainc.cpp

dwdllc.obj: dwdll.cpp dwdll.h gsdll.h
	$(COMPDIR)\$(COMP) -c -I$(INCDIR) -WC -odwdllc.obj dwdll.cpp

dwnodllc.obj: dwnodll.cpp dwdll.h gsdll.h
	$(COMPDIR)\$(COMP) -c -I$(INCDIR) -WC -odwnodllc.obj dwnodll.cpp


# windowcompat executable
!if $(MAKEDLL)
$(GSCONSOLE).exe: $(OBJC) $(GS).res dw32c.def
	$(COMPDIR)\tlink32 /Tpe /ap $(LCT) $(DEBUGLINK) @&&!
$(LIBDIR)\c0w32 +
$(OBJC) +
,$(GSCONSOLE).exe,$(GSCONSOLE), +
$(LIBDIR)\import32 +
$(LIBDIR)\cw32, +
dw32c.def, +
$(GS).res
!
!else
OBJCNO=dwmainc.obj dwnodllc.obj
$(GSCONSOLE).exe:  $(GS_ALL) $(DEVS_ALL) gsdll.$(OBJ) $(OBJCNO) $(GS).res dw32c.def
	copy $(ld_tr) gswin32.tr
	echo $(OBJCNO) + >> gswin32.tr
	tlink32 $(LCT) /Tpe /ap $(LIBDIR)\c0w32 gsdll @gswin32.tr $(INTASM) ,$(GSCONSOLE),$(GSCONSOLE),@lib.tr @$(LIBCTR),dw32c.def,$(GS).res
	-del gswin32.tr
!endif


# Access to 16 spooler from Win32s

gs16spl.exe: gs16spl.c gs16spl.rc
	$(CCAUX) -W -ms -c -v -I$(INCDIR) $*.c
	$(COMPDIR)\brcc -i$(INCDIR) -r $*.rc
	$(COMPDIR)\tlink /Twe /c /m /s /l @&&!
$(LIBDIR)\c0ws +
$*.obj +
,$*.exe,$*, +
$(LIBDIR)\import +
$(LIBDIR)\mathws +
$(LIBDIR)\cws, +
$*.def
!
	$(COMPDIR)\rlink -t $*.res $*.exe
