// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "gui.h"

TabInfo::TabInfo(FXComposite *f) :
FXVerticalFrame(f, FRAME_THICK | FRAME_RAISED)
{
	static char hdr[2][80];

	sprintf(hdr[0], "Bayonne Server Version %s", SYS_VERSION);
	sprintf(hdr[1], "Using %s driver plugin", plugins.getDriverName());
	mkheader(hdr[0]);
	mkheader(hdr[1]);

	mkfield(TIMESLOTS_TOTAL, "Total Timeslots:");
	mkfield(TIMESLOTS_AVAIL, "Avail Timeslots:");
	mkfield(INCOMING_CALLS, "Incoming Calls:");
	mkfield(INCOMING_TOTAL, "Incoming Total:");
	mkfield(OUTGOING_CALLS, "Outgoing Calls:");
	mkfield(OUTGOING_TOTAL, "Outgoung Total:");
	mkfield(NODES_TOTAL, "Total Nodes:");
	mkfield(NODES_AVAIL, "Avail Nodes:");

	setField(TIMESLOTS_TOTAL, "0");
	setField(TIMESLOTS_AVAIL, "0");
	setField(INCOMING_CALLS, "0");
	setField(OUTGOING_CALLS, "0");
	setField(INCOMING_TOTAL, "0");
	setField(OUTGOING_TOTAL, "0");
	setField(NODES_TOTAL, "1");
	setField(NODES_AVAIL, "1");
}

void TabInfo::mkheader(FXchar *text)
{
	FXLabel *label = new FXLabel(this, text, NULL, JUSTIFY_LEFT);
	label->setFont(gui.getBodyFont());
	label->setWidth(this->getWidth());
}

void TabInfo::mkfield(int id, FXchar *text)
{
	FXHorizontalFrame *horizontal = new FXHorizontalFrame(this, LAYOUT_SIDE_TOP|LAYOUT_FILL_X);
	FXLabel *label;

	label = new FXLabel(horizontal, text, NULL, JUSTIFY_LEFT, 0, 0, 230, 0);
	label->setFont(gui.getBodyFont());
	label = new FXLabel(horizontal, "", NULL, JUSTIFY_LEFT);
	label->setFont(gui.getBodyFont());
	data[id] = label;
}

