// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "gui.h"

GUIApp *GUIApp::first = NULL;

GUIApp::GUIApp() :
Debug(), Server(keythreads.priGUI()), FXApp("bayonne", "OST"), 
Keydata("/bayonne/gui")
{
	static KEYDEF keys[] = {
		{"width", "600"},
		{"height", "400"},
		{"points", "10"},
		{"typeface", "helvetica"},
		{"fixed", "fixed"},
		{NULL, NULL}};

	char *argv[2];
	int argc = 1;
	
	next = first;
	first = this;	

	Load("~bayonne/gui");
	Load(keys);
	
	argv[0] = "bayonne";
	argv[1] = NULL;
	
	init(argc, argv);

	menu = new FXFont((FXApp *)this, getTypeface(), getPoints(), 
		FONTWEIGHT_NORMAL, FONTSLANT_REGULAR, FONTENCODING_DEFAULT);

	title = new FXFont((FXApp *)this, getTypeface(), getPoints() + 2,
		FONTWEIGHT_BOLD, FONTSLANT_REGULAR, FONTENCODING_DEFAULT);

	fixed = new FXFont((FXApp *)this, getFixed(), getPoints() + 2);

	body = new FXFont((FXApp *)this, getTypeface(), getPoints() + 2,
		FONTWEIGHT_NORMAL, FONTSLANT_REGULAR, FONTENCODING_DEFAULT);

	main = new GUIMain((FXApp *)this);
}

void GUIApp::Stop()
{
	slog(SLOG_DEBUG) << "gui: stopping" << endl;
	Terminate();
	destroy();
}

void GUIApp::Initial(void)
{
	slog(SLOG_DEBUG) << "gui: starting session" << endl;
	create();
	main->show();
}

void GUIApp::Run(void)
{
	setCancel(THREAD_CANCEL_IMMEDIATE);
	slog(SLOG_DEBUG) << "gui: running" << endl;
	run();
	kill(mainpid, SIGINT);
	slog(SLOG_DEBUG) << "gui: stopping session" << endl;
	Sleep(~0);
}

GUIApp gui;

