// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "driver.h"

bool VPBTrunk::answerHandler(TrunkEvent *event)
{
	timeout_t wakeup;

	switch(event->id)
	{
	case TRUNK_STOP_DISCONNECT:
	case TRUNK_LINE_WINK:
	case TRUNK_CPA_DIALTONE:
	case TRUNK_TIMER_EXPIRED:
		flags.dsp = DSP_MODE_INACTIVE;
		TrunkSignal(TRUNK_SIGNAL_HANGUP);
		handler = &VPBTrunk::stepHandler;
		return true;
	case TRUNK_ENTER_STATE:
		if(flags.offhook)
		{
			TrunkSignal(TRUNK_SIGNAL_STEP);
			handler = &VPBTrunk::stepHandler;
			return true;
		}
		status[id] = 'r';
		debug->DebugState(this, "answer");
	case TRUNK_RINGING_OFF:
		if(rings > 1)
			flags.dsp = DSP_MODE_INACTIVE;

		if(data.answer.rings > rings)
		{
			setTimer(data.answer.timeout);
			return true;
		}
		flags.dsp = DSP_MODE_INACTIVE;
		if(!flags.offhook)
		{
			setOffhook();
			return true;
		}
	case TRUNK_OFF_HOOK:
		TrunkSignal(TRUNK_SIGNAL_STEP);
		handler = &VPBTrunk::stepHandler;
		status[id] = 'i';
		return true;
	}
	return false;
}
