// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of Bayonne as noted here.
//
// This exception is that permission is hereby granted to link Bayonne 
// with  the Pika MonteCarlo libraries to produce a executable image
// without requiring MonteCarlo itself to be supplied in source form so
// long as each source file so linked contains this exclusion.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name Bayonne.  If you copy code from other releases into a copy of
// Bayonne, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to Bayonne, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#include "server.h"

bool Trunk::scrRecord(void)
{
	data.record.name = getValue("");	
	if(!data.record.name)
	{
		Error("record-no-file");
		return true;
	}

	data.record.timeout = (timeout_t)getTimeout() * 1000l;
	data.record.term = getDigitMask();
	data.record.offset = 0;
	data.record.volume = atoi(getSymbol("volume"));
	data.record.trim = atoi(getSymbol("trim"));
	data.record.append = false;
	TrunkStep(TRUNK_STEP_RECORD);
	return false;
}

bool Trunk::scrAppend(void)
{
	data.record.name = getValue("");	
	if(!data.record.name)
	{
		Error("append-no-file");
		return true;
	}

	data.record.timeout = (timeout_t)getTimeout() * 1000l;
	data.record.term = getDigitMask();
	data.record.offset = 0;
	data.record.volume = atoi(getSymbol("volume"));
	data.record.trim = atoi(getSymbol("trim"));
	data.record.append = true;
	TrunkStep(TRUNK_STEP_RECORD);
	return false;
}

bool Trunk::scrTransfer(void)
{
	strstream str(data.dialxfer.digits, sizeof(data.dialxfer.digits) - 1); 
	char *cp;

	while(NULL != (cp = getValue(NULL)))
		str << cp;

	str << ends;
	data.dialxfer.digits[sizeof(data.dialxfer.digits) - 1] = 0;
	data.dialxfer.interdigit = group->getDialspeed();
	data.dialxfer.digit = data.dialxfer.digits;
	data.dialxfer.exit = true;
	TrunkStep(TRUNK_STEP_DIALXFER);
	return false;
}

bool Trunk::scrSpeak(void)
{
	Translator *tts;
	char *err;

	tts = getTranslator(getSymbol("language"));

	if(!tts)
	{
		Error("language-unsupported");
		return true;
	}
	err = tts->Speak(this);
	if(err)
	{
		Error(err);
		return true;
	}
	while(*data.play.name == ',')
		++data.play.name;

	data.play.volume = atoi(getSymbol("volume"));
	TrunkStep(TRUNK_STEP_PLAY);
	return false;
}
	
bool Trunk::scrDial(void)
{
	strstream str(data.dialxfer.digits, sizeof(data.dialxfer.digits) - 1); 
	char *cp;

	while(NULL != (cp = getValue(NULL)))
		str << cp;

	str << ends;
	data.dialxfer.digits[sizeof(data.dialxfer.digits) - 1] = 0;
	data.dialxfer.interdigit = group->getDialspeed();
	data.dialxfer.digit = data.dialxfer.digits;
	data.dialxfer.exit = false;
	TrunkStep(TRUNK_STEP_DIALXFER);
	return false;
}

bool Trunk::scrPlay(void)
{
	strstream str(data.play.list, sizeof(data.play.list) - 1);
	char *cp;
	
	while(NULL != (cp = getValue(NULL)))
		str << "," << cp;

	str << ends;
	data.play.list[sizeof(data.play.list) - 1] = 0;
	data.play.name = data.play.list;
	data.play.volume = atoi(getSymbol("volume"));
	while(*data.play.name == ',')
		++data.play.name;

	if(!*data.play.name)
	{
		Error("play-no-files");
		return true;
	}

	data.play.limit = data.play.offset = 0;
	TrunkStep(TRUNK_STEP_PLAY);
	return false;
}	

bool Trunk::scrFlash(void)
{
	data.flash.onhook = atol(getValue(group->getLast("flash")));
	data.flash.offhook = atol(getValue(group->getLast("dialtone")));
	TrunkStep(TRUNK_STEP_FLASH);
	return false;
}

bool Trunk::scrCollect(void)
{
	data.collect.count = atoi(getValue("0"));
	if(data.collect.count > 32)
		data.collect.count = 32;

	data.collect.timeout = getInterdigit() * 1000;
	data.collect.term = getDigitMask();
	data.collect.ignore = getDigitMask();
	TrunkStep(TRUNK_STEP_COLLECT);
	return false;
}

bool Trunk::scrAnswer(void)
{
	data.answer.rings = atoi(getValue("0"));
	data.answer.timeout = atol(getValue(group->getLast("ringtime"))) * 1000;
	TrunkStep(TRUNK_STEP_ANSWER);
	return false;
}	

bool Trunk::scrHangup(void)
{
	if(!Signal((unsigned int)0))
		scrExit();

	return true;
}

bool Trunk::scrAudit(void)
{
	cdrc = 0;
	char *val;

	while(cdrc < 32)
	{
		val = getOption(NULL);
		if(!val)
			break;

		cdrv[cdrc++] = val;
	}
	Advance();
	return true;
}

bool Trunk::scrAlog(void)
{
	char buffer[256];
	strstream str(buffer, 256);
	char *val;

	buffer[0] = 0;
	while(NULL != (val = getValue(NULL)))
		str << val;

	str << endl;
	audit(buffer + 1);
	Advance();
	return true;
}

bool Trunk::scrImport(void)
{
	scriptsymbol_t *sym;
	char *name;
	char *value;

	while(NULL != (name = getOption(NULL)))
	{
		if(*name++ != '%')
			continue;

		value = globals.getSymbol(name);
		if(!value)
			continue;

		setSymbol(name, getSymbolSize());
		setSymbol(name, value);
	}
	Advance();
	return true;
}

bool Trunk::scrDebug(void)
{
	char buf[256];
	char *value;

	buf[0] = 0;
	while(NULL != (value = getValue(NULL)))
		strcat(buf, value);
	debug->DebugScript(this, buf);
	Advance();
	return true;
}

bool Trunk::scrPack(void)
{
	scriptsymbol_t *sym;
	char *name = getOption(NULL);
	char *value;
	int len = 0;
	char *pp;

	if(!name)
	{
		Error("symbol-not-found");
		return true;
	}

	if(*name == '@')
		sym = getIndirect(++name);
	else if(*name == '%')
		sym = getEntry(++name, getSymbolSize());
	else
		sym = NULL;

	if(!sym)
	{
		Error("symbol-not-found");
		return true;
	}

	if(sym->flags.readonly)
	{
		Error("symbol-read-only");
		return true;
	}
	
	pp = sym->data;
	while(len < sym->flags.size && NULL != (value = getValue(NULL)))
	{
		while(*value && len++ < sym->flags.size)
			*(pp++) = *(value++);
	
		if(len < sym->flags.size)
			*(pp++) = ',';
	}
	*pp = 0;
	sym->flags.initial = false;
	if(sym->flags.commit)
		Commit(sym);
	Advance();
	return true;
}

bool Trunk::scrUnpack(void)
{
	scriptsymbol_t *sym;
	char *pp;
	char *name;
	char *gp = getValue(NULL);
	int len;
	
	if(!name)
	{
		Error("source-not-found");
		return true;
	}

	while(*gp && NULL != (name = getOption(NULL)))
	{
		if(*name == '@')
			sym = getIndirect(++name);
		if(*name == '%')
			sym = getEntry(++name, getSymbolSize());
		else
			sym = NULL;

		if(sym)
		{
			if(sym->flags.readonly)
				pp = NULL;
			else
				pp = sym->data;
		}
		else
			pp = NULL;

		len = 0;
		while(pp && *gp && *gp != ',')
		{
			if(++len > sym->flags.size)
				break;
			*(pp++) = *(gp++);
		}

		if(pp)
		{
			*pp = 0;
			sym->flags.initial = false;
			if(sym->flags.commit)
				Commit(sym);
		}

		while(*gp && *gp != ',')
			++gp;

		if(*gp == ',')
			++gp;
	}
	Advance();
	return true;	
}	

bool Trunk::scrExport(void)
{
	scriptsymbol_t *sym;
	char *name;

	while(NULL != (name = getOption(NULL)))
	{
		if(*name != '%')
			continue;

		sym = getEntry(++name, 0);
		if(!sym)
			continue;

		globals.setSymbol(name, sym->flags.size);
		globals.setSymbol(name, sym->data);
	}
	Advance();
	return true;
}

bool Trunk::scrWait(void)
{
	int timer = atoi(getValue("0"));
	time_t now;

	time(&now);
	timer = timer - (now - start);
	if(timer < 1)
	{
		Advance();
		return true;
	}
	data.sleep.wakeup = timer * 1000;
	data.sleep.rings = atoi(getValue("0"));
	data.sleep.loops = 1;
	TrunkStep(TRUNK_STEP_SLEEP);
	return false;
}

bool Trunk::scrPause(void)
{
	data.sleep.wakeup = atol(getValue("0"));
	data.sleep.loops = 1;
	if(data.sleep.wakeup < 20)
		data.sleep.wakeup = 20;

	data.sleep.rings = 0;
	TrunkStep(TRUNK_STEP_SLEEP);
	return false;
}

bool Trunk::scrLibexec(void)
{
	tgicmd_t cmd;
	char query[128];
	strstream str(cmd.cmd, 254);
	strstream q(query, 128);
	char *qc;

	int cnt = 0;
	int args = 0;
	data.sleep.wakeup = atoi(getValue("0")) * 1000;
	data.sleep.rings = 0;
	data.sleep.loops = 1;
	if(!data.sleep.wakeup)
	{
		Advance();
		return true;
	}

	cmd.port = id;
	cmd.cmd[0] = 0;
	query[0] = 0;
	
	str << getValue("--");
	while(NULL != (qc = getOption(NULL)))
	{
		if(*qc != '%')
			continue;

		if(!query[0])
			q << qc << "=" << getContent(qc);
		else
			q << keyserver.getToken() << qc << "=" << getContent(qc);
	}
	q << ends;
	str << " query=" << query;
	
	str << " digits=" << dtmf.bin.data;		

	qc = getSymbol("ani");
	if(qc)
		str << " ani=" << qc;

	qc = getSymbol("dnis");
	if(qc)
		str << " dnis=" << qc;

	qc = getSymbol("did");
	if(qc)
		str << " did=" << qc;

	qc = getSymbol("callerid");
	if(qc)
	{
		str << " cid=" << qc;
		qc = getSymbol("callername");
		if(qc)
			str << keyserver.getToken() << qc;
	}

	str << ends;
	::write(tgipipe[1], &cmd, sizeof(cmd));
		
	TrunkStep(TRUNK_STEP_SLEEP);
	return false;
}

bool Trunk::scrRetry(void)
{
	int timer;
	if(tgi.data)
	{
		Advance();
		return true;
	}
	if(!database)
	{
		Error("retry-not-loaded");
		return true;
	}
	timer = database->Lookup(tgi.seq, this);
	if(timer < 0)
	{
		Error("retry-error");
		return true;
	}
	if(!timer)
	{
		Advance();
		return true;
	}
	data.sleep.wakeup = timer * 1000;
	data.sleep.loops = 1;
	data.sleep.rings = 0;
	TrunkStep(TRUNK_STEP_SLEEP);
	return false;
}	

bool Trunk::scrSubmit(void)
{
	char *err;

	if(!database)
		err = "no-database";
	else
		err = database->Submit(this);

	if(err)
	{
		Error(err);
		return true;
	}
	Advance();
	return true;
}

bool Trunk::scrLogout(void)
{
	if(!session)
	{
		Error("no-login");
		return true;
	}
	Logout();
	Advance();
	return true;
}

bool Trunk::scrSession(void)
{
	int timer;
	scriptline_t *line = getScript();

	if(!database)
	{
		Error("dbase-not-loaded");
		return true;
	}
	if(!session)
	{
		Error("no-login");
		return true;
	}
	timer = database->Session(++tgi.seq, line->cmd, this);
	if(timer < 0)
	{
		Error("bad-session");
		return true;
	}
	if(!timer)
	{
		Advance();
		return true;
	}
	tgi.data = (void *)-1;
	data.sleep.wakeup = timer * 1000;
	data.sleep.loops = 1;
	data.sleep.rings = 0;
	TrunkStep(TRUNK_STEP_SLEEP);
	return false;
}

bool Trunk::scrLogin(void)
{
	int timer;
	if(!database)
	{
		Error("dbase-not-loaded");
		return true;
	}

	setSymbol("login", database->getLoginSize());
	Logout();
	setSymbol("login", "");

	timer = database->Login(++tgi.seq, this);

	if(timer < 0)
	{
		Error("login-error");
		return true;
	}
	if(!timer)
	{
		session = getSymbol("login");
		Advance();
		return true;
	}
	tgi.data = (void *)-1;
	data.sleep.wakeup = timer * 1000;
	data.sleep.loops = 1;
	data.sleep.rings = 0;
	TrunkStep(TRUNK_STEP_SLEEP);
	return false;
}

bool Trunk::scrLookup(void)
{
	int timer;

	if(!database)
	{
		Error("dbase-not-loaded");
		return true;
	}
	timer = database->Lookup(++tgi.seq, this);

	tgi.data = (void *)-1;
	if(timer < 0)
	{
		Error("lookup-error");
		return true;
	}
	if(!timer)
	{
		Advance();
		return true;
	}
	tgi.data = NULL;			
	data.sleep.wakeup = timer * 1000;
	data.sleep.loops = 1;
	data.sleep.rings = 0;
	TrunkStep(TRUNK_STEP_SLEEP);
	return false;
}

bool Trunk::scrTone(void)
{
	phTone *tone = getphTone(getValue(""));
	if(!tone)
	{
		Error("no-tone");
		return true;
	}
	data.tone.tone = tone;
	data.tone.wakeup = atol(getValue("0"));
	data.tone.loops = atoi(getValue("1"));
	TrunkStep(TRUNK_STEP_TONE);
	return false;
}


bool Trunk::scrSleep(void)
{
	int timer = atoi(getValue("0"));

	if(!timer)
	{
		Advance();
		return true;
	}

	data.sleep.wakeup = timer * 1000;
	data.sleep.loops = 1;
	data.sleep.rings = 0;
	TrunkStep(TRUNK_STEP_SLEEP);
	return false;
}

bool Trunk::scrFunction(void)
{
	char *name = getOption(NULL);
	scriptsymbol_t *sym = getEntry(name, getSymbolSize());
	functioncall_t fun = driver->getFunction(name);
	char *argv[32];
	int count = 0;

	if(!fun)
	{
		Error("function-not-found");
		return true;
	}

	if(!sym)
	{
		Error("symbol-not-found");
		return true;
	}

	if(sym->flags.readonly)
	{
		Error("symbol-readonly");
		return true;
	}

	sym->data[sym->flags.size] = 0;
	while(count < 31)
	{
		argv[count] = getValue();
		if(!argv[count])
			break;
		++count;
	}
	argv[count] = NULL;
	name = (*fun)(sym, argv);
	if(name)
		Error(name);
	else
	{
		sym->flags.initial = false;
		if(sym->flags.commit)
			Commit(sym);
		Advance();
	}
	return true;
}
