#!/usr/bin/perl

use strict;
use warnings 'all';
no warnings 'uninitialized';
no locale;

# code name script dict gettext

my (%L, %LL, # code => [code, name, scripts, dict, gettext]
    %S);# script => class

my @skip = qw(no);
my @nospace = qw(Thai Leo Khmer);

sub oneof ( $ @ ) {return grep {$_ eq $_[0]} @_[1 .. $#_];}

sub trim ( \@ \@ ) {return grep {oneof $_, @{$_[1]}} @{$_[0]};}

open F, "lang.txt";
while (<F>) {
  my ($c, $l) = /(.+?)\t(.+?)\n/ or die;
  next if oneof $c, @skip;
  $L{$c} = [$c, $l];
};

open F, "scripts.txt";
my $script;
while (<F>) {
  chop;
  next unless /\w/;
  if (/(.+):/) {
    $script = $1;
  } elsif (/(\w+)\s*$/) {
    #next unless length($1) == 2;
    next if oneof $1, @skip;
    die unless $L{$1};
    push @{$L{$1}[2]}, $script;
    $S{$script} = undef;
  } else {
    die unless /(\w+).?\s*/;
  }
}

open F, "class.txt";
my (@alpha, @unsup);
my $class;
while (<F>) {
  chop;
  next unless /\w/;
  if (/(.+):/) {
    $class = $1;
  } elsif (/\s*(.+?)\*?\s*(\(.+?\)\s*)?$/) {
    next unless exists $S{$1};
    if (oneof $class, qw(Abjads Alphabets Alphasyllabaries Syllabaries)
        and not oneof $1, @nospace)  {push @alpha, $1}
    else                             {push @unsup, $1}
    $S{$1} = $class;
    #print "$class $1\n";
  } else {
    die;
  }
}

foreach (keys %S) {print "ERROR: Unknown class $_\n" unless defined $S{$_};}

sub f ( $ $ ) {
  my $i = shift;
  my $name = shift;
  my @inf = ([' ', 'Yes',          0],
             ['E', 'Experimental', 0],
             ['I', 'Incomplete',   0],
             ['P', 'Planned',      0],
             ['M', 'Maybe',        0]);
  open F, "$name.txt";
  while (<F>) {
    my ($l, @d) = split /\s+/;
    die "Unknown lang '$l'" unless $L{$l};
    my $n = 1;
    $n++ while ($n != @inf && $inf[$n][0] ne $d[0]);
    $n = 0 if $n == @inf;
    my $what = $inf[$n][1];
    $inf[$n][2]++;
    $L{$l}[$i] = $what;
  }
  close F;
  print "$name:\n";
  my $total = 0;
  foreach (@inf) {
    $total += $_->[2];
    printf "  %-12s %3d %3d\n", $_->[1], $_->[2], $total;
  }
}

f 3, "dict";
f 4, "trans";

while (my ($k, $v) = each %L) {
  $LL{$k} = $L{$k};
  if (length($k) == 2 || defined $v->[3] || defined $v->[4]) {
    die "$k has unknown script" unless defined $v->[2];
  } else {
    delete $L{$k};
  }
}

#
#
#

sub table ( $ @ ) {

  my $file = shift;
  my @which = @_;
  my $path = "/home/kevina/aspell/manual/$file.texi";

  open F, ">$path" or die;

  my @max = ('Code','','','Dictionary', 'Translation');
  my $prev = ' ';
  my $table = '';

  foreach my $k (sort keys %L) {
    my @d = @{$L{$k}};
    my (@s) = trim @{$d[2]}, @which;
    next unless @s;
    $d[2] = join ', ', @s;
    $table .= "\@item\n" if substr($prev,0,1) ne substr($d[0],0,1);
    $table .= "\@item ";
    $table .= "$d[0] \@tab \@tab "       if $prev eq $d[0];
    $table .= "$d[0] \@tab $d[1] \@tab " if $prev ne $d[0];
    $table .= join (" \@tab ", map {length $_ ? $_ : '-'} @d[2,3,4]) . "\n";
    for my $i (0..4) 
      {foreach (split /\s+/, $d[$i]) 
         {$max[$i] = $_ if length $max[$i] < length $_}}
    $prev = $d[0];
  }

  print F '@multitable @columnfractions 0.05 0.31 0.29 0.20 0.15', "\n";
  #join(" ", map {"{${_}}"} @max), "\n";
  print F '@item @b{Code} @tab @b{Language Name} @tab @b{Script} @tab @b{Dictionary Available} @tab @b{Gettext Translation}', "\n";
  print F "$table\n";
  print F "\@end multitable\n";
}

sub table2 ( $ @ ) {

  my $file = shift;
  my @which = @_;
  my $path = "/home/kevina/aspell/manual/$file.texi";

  open F, ">$path" or die;

  my @max = ('Code','Language Name','Script');
  my $prev = ' ';
  my $table = '';

  foreach my $k (sort keys %L) {
    my @d = @{$L{$k}};
    my (@s) = trim @{$d[2]}, @which;
    next unless @s;
    $d[2] = join ', ', @s;
    $table .= "\@item ";
    $table .= "$d[0] \@tab \@tab "       if $prev eq $d[0];
    $table .= "$d[0] \@tab $d[1] \@tab " if $prev ne $d[0];
    $table .= "$d[2]\n";
    for my $i (0 .. 2) {$max[$i] = $d[$i] if length $max[$i] < length $d[$i]}
    $prev = $d[0];
  }

  print F "\@multitable ", join(" ", map {"{${_}}"} @max), "\n";
  print F '@item @b{Code} @tab @b{Language Name} @tab @b{Script}', "\n";
  print F "$table\n";
  print F "\@end multitable\n";
}

table 'lang-supported', @alpha;
table2 'lang-unsupported', @unsup;

sub otrans ( $ $ ) {
  my $i = shift;
  my $name = shift;

  open F, "$name.txt";

  while (<F>) {
    my ($l, $n) = split /\s+/;
    next if oneof $l, @skip;
    $l = 've' if $l eq 'ven';
    die "Unknown lang '$l'" unless $LL{$l};
    print "Unknown script '$l'\n" unless $LL{$l}[2];
    $LL{$l}[$i] = $n;
  }
}

otrans 5, 'gnome';
otrans 6, 'kde';

open F, ">res.html";

my @d;

sub table3 (&) {
  print F "<table>\n";
  print F "<tr><th>Code<th>Name<th>Script<th>Dictionary<th>Trans<th>Gnome<th>KDE</tr>\n";
  my $c = 0;
  foreach my $k (sort keys %LL) {
    @d = @{$LL{$k}};
    next unless defined $d[5] || defined $d[6];
    my (@s) = trim @{$d[2]}, @alpha;
    next unless @s;
    $d[2] = join ', ', @s;
    next unless &{$_[0]};
    print F "<tr>";
    foreach (0..6) {
      $_ = $d[$_];
      $_ = '-' unless defined $_;
      print F "<td>$_</td>";
    }
    print F "</tr>\n";
    $c++;
  }
  print F "</table>\n";
  print F "<p><i>Total: $c</i><p>\n";
}

#print F "<h3>To Look Into: Latin</h3>\n";
#table3 {!defined $d[3] && ($d[5] >= 8 || $d[6] >= 8) && $d[2] =~ /Latin/};

print F "<h3>To Look Into</h3>\n";
table3 {!defined $d[3] && ($d[5] >= 15 || $d[6] >= 15)};

print F "<h3>Maybe</h3>\n";
table3 {!defined $d[3] && !($d[5] >= 15 || $d[6] >= 15)};


print F "<h3>Possible Proofreaders</h3>\n";
table3 {oneof $d[0], qw(ast ceb ch kw fy haw oc tpi)};



