#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "interface.h"

#include "treedata.h"

int do_pick_node(c, e, x, y, f)
tcanvas c;
tevent e;
int x, y;
int (*f)();
{
	static treenode n;
	static command cm;
	static int result;
	static treenode lastnode;
	static unsigned long lasttime, thistime;

	result=0;

	if(installing)
	{
		lastnode=NULL;
		canvas_add_event_function(do_pick_node, f);
		return(1);
	}
	else if(uninstalling)
	{
		canvas_remove_event_function(do_pick_node);
		return(1);
	}
	else if(printing) printf("zpicknode\n");

	switch(tevent_type(e))
	{
		case te_mousedown:
			n=(treenode)which_node(c, x, y);
			if(n!=NULL)
			{
                thistime=tevent_time(e);
                if(lastnode==n && thistime-lasttime<DBLCLICK)
                {
                    /* double clicked on dragnode */
                    show_node_info_frame();
                    lastnode=NULL;
					result=1;
                }
                else
                {
                    lasttime=thistime;
                    lastnode=n;

					select_by_state(NodeSubtreeSel, n, 0.0, e);
					if(globals->mode==MouseText && ndta(n)->selected)
					{
						uninstall(do_change_text);
						install(do_change_text, NULL);
					}
					result=1;
				}
			}
			break;
		default:
			break;
	}
	return(result);
}
