#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "interface.h"

#include "treedata.h"

int flip_node(n)
treenode n;
{
	list c, f, b;
	int first=1;
	double x, y;
	double x1, x2, y1, y2;
	double mx1, mx2, my1, my2;
	double ty, a1, a2, ta1, ta2, pa;
	nodetypedata nd;

	if(treechildren(n)<=1)
		return(0);
	fliplist(n);

	/* adjust boxed format */
	tforsubtree(n, c)
	{
		if(first)
		{
			subtree_full_extents(subtree(c), Boxed, &mx1, &my1, &mx2, &my2);
			first=0;
		}
		else
		{
			subtree_full_extents(subtree(c), Boxed, &x1, &y1, &x2, &y2);
			if(y1<my1)
				my1=y1;
			if(y2>my2)
				my2=y2;
		}
	}
	/* now my1 = top of subtrees, my2=bottom of subtrees */
	tforsubtree(n, c)
	{
		subtree_full_extents(subtree(c), Boxed, &x1, &y1, &x2, &y2);
		ty=(my2-y2)-(y1-my1);
		move_subtree(subtree(c), Boxed, 0.0, ty);
	}
	node_full_extents(n, Boxed, &x1, &y1, &x2, &y2);
	ty=(my2-y2)-(y1-my1);
	move_node(n, Boxed, 0.0, ty);

	/* adjust flower format */
	first=1;
	nd=tndta(n, Flower);
	pa=nd->a;
	tforsubtree(n, c)
	{
		subtree_range(subtree(c), Flower, &ta1, &ta2);
		ta1-=pa+M_PI;
		pos_angle(ta1);
		ta2-=pa+M_PI;
		pos_angle(ta2);
		if(first)
		{
			first=0;
			a1=ta1;
			a2=ta2;
		}
		else
		{
			if(ta1<a1)
				a1=ta1;
			if(ta2>a2)
				a2=ta2;
		}
	}
	/* now subtree extents are in subtree->nd */
	/* maxes are a1,a2 */
	tforsubtree(n, c)
	{
		nd=tndta(subtree(c), Flower);
		ta1=nd->a1-pa-M_PI;
		pos_angle(ta1);
		ta2=nd->a2-pa-M_PI;
		pos_angle(ta1);
		
		rotate_subtree(subtree(c), Flower, a1+a2-ta1-ta2);
	}

	invalidate_refit(tree_get_tree(n), Flower);
	invalidate_labels(tree_get_tree(n), Flower);
	invalidate_format(tree_get_tree(n), Flower);
	invalidate_spacing(tree_get_tree(n), Flower);
	invalidate_spacing(tree_get_tree(n), Boxed);

	canvas_add_node(parent(n));
	canvas_add_subtree(n);
	modify();
	
	return(1);
}
