package test.contrib.tabledatefield;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.swing.JTextField;

/**
 * Copyright 2008 Computer Science Software (Pty) Ltd. South Africa.
 * Stripped-down for Substance hover issue demo.
 * 
 * @author DP
 * 
 * 05-Apr-2003 : Created class (DP)
 */

public class DateField extends JTextField {

	protected static final SimpleDateFormat formatDMYYYY = new SimpleDateFormat(
			"d M yyyy");
	protected static final SimpleDateFormat defaultDateFormat = new SimpleDateFormat(
			"d MMM yyyy");
	protected static final SimpleDateFormat formatDMMMMYYYY = new SimpleDateFormat(
			"d MMMM yyyy");
	protected static final SimpleDateFormat formatDDMMYYYY = new SimpleDateFormat(
			"ddMMyyyy");
	protected static final SimpleDateFormat formatDMMMYYYY = new SimpleDateFormat(
			"d MMM yyyy");

	protected static final SimpleDateFormat formatDMYYYY_HMM = new SimpleDateFormat(
			"d M yyyy H mm");
	protected static final SimpleDateFormat defaultDateTimeFormat = new SimpleDateFormat(
			"d MMM yyyy H mm");
	protected static final SimpleDateFormat formatDMMMMYYYY_HMM = new SimpleDateFormat(
			"d MMMM yyyy H mm");
	protected static final SimpleDateFormat formatDDMMYYYY_HMM = new SimpleDateFormat(
			"ddMMyyyy H mm");
	protected static final SimpleDateFormat formatDMMMYYYY_HMM = new SimpleDateFormat(
			"d MMM yyyy H mm");

	protected boolean hasChanged = false;
	protected SimpleDateFormat dateFormat;

	public DateField(SimpleDateFormat newDateFormat) {
		super(4);

		this.dateFormat = newDateFormat;
		eventInit();
	}

	public DateField(int columns) {
		super(columns);

		this.dateFormat = defaultDateFormat;
		eventInit();
	}

	public DateField() {
		this(defaultDateFormat);
	}

	private void eventInit() {
		this.addFocusListener(new FocusAdapter() {
			@Override
			public void focusLost(FocusEvent e) {
				if (hasChanged == true) {
					hasChanged = false;
				}
			}
		});
	}

	public boolean getHasChanged() {
		return this.hasChanged;
	}

	public void setHasChanged(boolean newHasChanged) {
		this.hasChanged = newHasChanged;
	}

	public void setValue(Date value) {
		try {
			if (value != null) {
				setText(this.dateFormat.format(value));
			} else {
				setText(null);
			}
		} catch (IllegalStateException exc1) {
			// Do nothing.
		} catch (Exception exc2) {
			exc2.printStackTrace();
		}
	}

	public Date getValue() {
		// aktivateChecker();

		if (getText() != null && getText().trim().equals("") == false
				&& getText().trim().length() > 7) {
			try {
				try {
					return formatDMYYYY_HMM.parse(getText());
				} catch (ParseException e1) {
					try {
						return defaultDateTimeFormat.parse(getText());
					} catch (ParseException e2) {
						try {
							return formatDMMMMYYYY_HMM.parse(getText());
						} catch (ParseException e3) {
							try {
								return formatDDMMYYYY_HMM.parse(getText());
							} catch (ParseException e4) {
								try {
									return formatDMMMYYYY_HMM.parse(getText());
								} catch (ParseException e5) {
									try {
										return formatDMYYYY.parse(getText());
									} catch (ParseException e6) {
										try {
											return this.dateFormat
													.parse(getText());
										} catch (ParseException e7) {
											try {
												return defaultDateFormat
														.parse(getText());
											} catch (ParseException e8) {
												try {
													return formatDMMMMYYYY
															.parse(getText());
												} catch (ParseException e9) {
													try {
														return formatDDMMYYYY
																.parse(getText());
													} catch (ParseException e10) {
														try {
															return formatDMMMYYYY
																	.parse(getText());
														} catch (ParseException e11) {
															// System.err.println("DateField
															// >> getValue: could not parse:
															// " + getText());
															return null;
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			} catch (NumberFormatException exc) {
			} catch (Exception exc) {
				exc.printStackTrace();
			}
		}

		return null;
	}

	@Override
	public void setEditable(boolean flag) {
		super.setEditable(flag);
		// super.setBorder(null);
	}
}